//  Раскомментируйте для программной реализации шины I2C:              //
//  #define pin_SW_SDA 3                                               // Назначение любого вывода Arduino для работы в качестве линии SDA программной шины I2C.
//  #define pin_SW_SCL 9                                               // Назначение любого вывода Arduino для работы в качестве линии SCL программной шины I2C.
//  Раскомментируйте для совместимости с большинством плат:            //
//  #include <Wire.h>                                                  // Библиотека iarduino_OLED будет использовать методы и функции библиотеки Wire.
//  Ссылки для ознакомления:                                           //
//  Подробная информация о подключении модуля к шине I2C:              // http://wiki.iarduino.ru/page/i2c_connection/
//  Подробная информация о функциях и методах библиотеки:              // http://wiki.iarduino.ru/page/OLED_trema/
//  Библиотека  iarduino_OLED_txt (текстовая) экономит ОЗУ:            // http://iarduino.ru/file/341.html
//  Бибилиотека iarduino_OLED     (графическая):                       // http://iarduino.ru/file/340.html
                                                                       // 
#include <iarduino_OLED.h>                                             // Подключаем библиотеку iarduino_OLED.
iarduino_OLED  myOLED(0x3C);                                           // Объявляем объект myOLED, указывая адрес дисплея на шине I2C: 0x3C или 0x3D.
                                                                       //
const uint8_t  myImageInRAM[] =                                        // Создаём массив myImageInRAM содержащий изображение смайлика. Массив хранится в области ОЗУ (RAM).
{   9, 8,             //                  ЛЕВО                         // Первые два числа, это размеры изображения: ширина 9px, высота 8px. Высота изображения всегда должна быть кратна 8 (8,16,24,32,...).
    B00111100,        //                  ####                         // = 0x3C
    B01000010,        //                 #    #                        // = 0x42
    B10010001,        //                #  #   #                       // = 0x91      Если байты массива указывать не в двоичной,
    B10100101,        //                # #  # #                       // = 0xA5      а в шестнадцатеричной системе счисления,
    B10100001,        //           НИЗ  # #    #  ВЕРХ                 // = 0xA1      то запись массива будет более короткой:
    B10100101,        //                # #  # #                       // = 0xA5
    B10010001,        //                #  #   #                       // = 0x91      const uint8_t myImageInRAM[]={9,8,0x3C,0x42,0x91,0xA5,0xA1,0xA5,0x91,0x42,0x3C};
    B01000010,        //                 #    #                        // = 0x42
    B00111100         //                  ####                         // = 0x3C
};                    //                 ПРАВО                         //
                                                                       //
const uint8_t  myImageInROM[] PROGMEM =                                // Создаём массив myImageInROM содержащий изображение смайлика. Массив хранится в области ПЗУ (ROM).
{9, 8, 0x3C, 0x42, 0x91, 0xA5, 0xA1, 0xA5, 0x91, 0x42, 0x3C};          // Данные этого массива аналогичны предыдущему, но записаны в 16-ричной системе счисления.
                                                                       //
void setup(){                                                          //
    myOLED.begin();                                                    // Инициируем работу с дисплеем.
                                                                       //
    myOLED.drawImage(myImageInRAM, 36, 27, IMG_RAM);                   // Выводим картинку myImageInRAM в позицию 36x27, указав, что картинка хранится в оперативной памяти (IMG_RAM).
    myOLED.drawImage(myImageInROM, 81, 27, IMG_ROM);                   // Выводим картинку myImageInRAM в позицию 81x27, указав, что картинка хранится в памяти программ (IMG_ROM).
                                                                       //
}                                                                      //
void loop(){}                                                          //

