//  Раскомментируйте для программной реализации шины I2C:              //
//  #define pin_SW_SDA 3                                               // Назначение любого вывода Arduino для работы в качестве линии SDA программной шины I2C.
//  #define pin_SW_SCL 9                                               // Назначение любого вывода Arduino для работы в качестве линии SCL программной шины I2C.
//  Раскомментируйте для совместимости с большинством плат:            //
//  #include <Wire.h>                                                  // Библиотека iarduino_OLED будет использовать методы и функции библиотеки Wire.
//  Ссылки для ознакомления:                                           //
//  Подробная информация о подключении модуля к шине I2C:              // http://wiki.iarduino.ru/page/i2c_connection/
//  Подробная информация о функциях и методах библиотеки:              // http://wiki.iarduino.ru/page/OLED_trema/
//  Библиотека  iarduino_OLED_txt (текстовая) экономит ОЗУ:            // http://iarduino.ru/file/341.html
//  Бибилиотека iarduino_OLED     (графическая):                       // http://iarduino.ru/file/340.html
                                                                       // 
#include <iarduino_OLED.h>                                             // Подключаем библиотеку iarduino_OLED.
iarduino_OLED myOLED(0x3C);                                            // Объявляем объект myOLED, указывая адрес дисплея на шине I2C: 0x3C или 0x3D.
                                                                       //
extern uint8_t SmallFontRus[];                                         // Подключаем шрифт SmallFontRus.
                                                                       // Если Вы не используете Кириллицу, то лучше подключить шрифт SmallFont, он займет меньше места в памяти программ.
void setup(){                                                          //
    myOLED.begin();                                                    // Инициируем работу с дисплеем.
    myOLED.setFont(SmallFontRus);                                      // Указываем шрифт который требуется использовать для вывода цифр и текста.
}                                                                      //
                                                                       //
void loop(){                                                           //
                                                                       //
//  Вывод текста в кодировке UTF-8:                                    //
    myOLED.clrScr();                                                   // Чистим экран.
    myOLED.print("UTF8", 0, 7);                                        // Выводим текст начиная с координаты 0x7 (нижняя левая точка текста).
    myOLED.setCoding(TXT_UTF8);                                        // Меняем кодировку на UTF-8 (по умолчанию).
    myOLED.print("Ардуино iArduino", OLED_C, 39);                      // Выводим текст по центру экрана, координата нижней части текста по оси Y равна 39.
    delay (5000);                                                      // Ждём 5 секунд.
                                                                       //
//  Вывод текста в кодировке CP866:                                    //
    myOLED.clrScr();                                                   // Чистим экран.
    myOLED.print("CP866", 0, 7);                                       // Выводим текст начиная с координаты 0x7 (нижняя левая точка текста).
    myOLED.setCoding(TXT_CP866);                                       // Меняем кодировку на CP866.
    myOLED.print("Ардуино iArduino", OLED_C, 39);                      // Выводим текст по центру экрана, координата нижней части текста по оси Y равна 39.
    delay (5000);                                                      // Ждём 5 секунд.
                                                                       //
//  Вывод текста в кодировке WINDOWS-1251:                             //
    myOLED.clrScr();                                                   // Чистим экран.
    myOLED.print("WIN1251", 0, 7);                                     // Выводим текст начиная с координаты 0x7 (нижняя левая точка текста).
    myOLED.setCoding(TXT_WIN1251);                                     // Меняем кодировку на WINDOWS-1251.
    myOLED.print("Ардуино iArduino", OLED_C, 39);                      // Выводим текст по центру экрана, координата нижней части текста по оси Y равна 39.
    delay (5000);                                                      // Ждём 5 секунд.
                                                                       //
//  Вывод текста по коду символов:                                     //
    myOLED.clrScr();                                                   // Чистим экран.
    myOLED.print("CODE", 0, 7);                                        // Выводим текст начиная с координаты 0x7 (нижняя левая точка текста).
    myOLED.setCoding(false);                                           // Отменяем кодировку.
    myOLED.print("\200\340\244\343\250\255\256 iArduino", OLED_C, 39); // Выводим текст по центру экрана, координата нижней части текста по оси Y равна 39.
    delay (5000);                                                      // Ждём 5 секунд.
}                                                                      //
                                                                       //
/*  КОДЫ СИМВОЛОВ:                                                     //
 *  Латинские буквы A-Z и a-z                                          // Вводятся как есть, вне зависимости от кодировки.
 *  Цифры 0-9 и символы !"#$%&'()*+,-./:;<=>?@[]^_`{|}~                // Вводятся как есть, вне зависимости от кодировки.
 *  Буквы АБВГДЕЖЗИЙКЛМНОП                                             // Код: 128-143 в 10-тичной системе счисления. 
 *  Буквы РСТУФХЦЧШЩЪЫЬЭЮЯ                                             // Код: 144-159 в 10-тичной системе счисления. 
 *  Буквы абвгдежзийклмноп                                             // Код: 160-175 в 10-тичной системе счисления. 
 *  Буквы рстуфхцчшщъыьэюя                                             // Код: 224-239 в 10-тичной системе счисления. 
 *  Буквы Ё,ё                                                          // Код: 240,241 в 10-тичной системе счисления. 
 *                                                                     //
 *  Для вывода буквы нужно указать её код в 8-ричной системе счисления //
 *  которому должен предшествовать символ \                            //
 *                                                                     //
 *  Пример вывода Русской буквы «А»:                                   //
 *  - буква «А» имеет код 128.                                         // Для перевода чисел из 10-тичной в 8-ричную систему можно воспользоваться стандартным калькулятором в windows.
 *  - 128 в 10-тичной системе равно числу 200 в 8-ричной системе.      // Выберите вид калькулятора - «Программист» и введите число, Вы увидите его представление в разных системах счисления: HEX(16), DEC(10), OCT(8) и BIN(2).
 *  - Значит буква «А» записывается как \200                           // Далее в примере следует буква «р» \340, «д» \244, «у» \343, «и» \250, «н» \255, «о» \256.
 *                                                                     //
 *  Запись текста кодами символов кажется более громоздкой, но         //
 *  на самом деле, такая запись занимает в 2 раза меньше памяти!       //
 */
