//  Раскомментируйте для программной реализации шины I2C:                 //
//  #define pin_SW_SDA 3                                                  // Назначение любого вывода Arduino для работы в качестве линии SDA программной шины I2C.
//  #define pin_SW_SCL 9                                                  // Назначение любого вывода Arduino для работы в качестве линии SCL программной шины I2C.
//  Раскомментируйте для совместимости с большинством плат:               //
//  #include <Wire.h>                                                     // Библиотека iarduino_OLED будет использовать методы и функции библиотеки Wire.
//  Ссылки для ознакомления:                                              //
//  Подробная информация о подключении модуля к шине I2C:                 // http://wiki.iarduino.ru/page/i2c_connection/
//  Подробная информация о функциях и методах библиотеки:                 // http://wiki.iarduino.ru/page/OLED_trema/
//  Библиотека  iarduino_OLED_txt (текстовая) экономит ОЗУ:               // http://iarduino.ru/file/341.html
//  Бибилиотека iarduino_OLED     (графическая):                          // http://iarduino.ru/file/340.html
                                                                          // 
#include <iarduino_OLED.h>                                                // Подключаем библиотеку iarduino_OLED.
iarduino_OLED myOLED(0x3C);                                               // Объявляем объект myOLED, указывая адрес дисплея на шине I2C: 0x3C или 0x3D.
                                                                          // 
extern uint8_t SmallFontRus[];                                            // Подключаем шрифт SmallFontRus.
                                                                          // Если Вы не используете Кириллицу, то лучше подключить шрифт SmallFont, он займет меньше места в памяти программ.
void setup(){                                                             //
    myOLED.begin();                                                       // Инициируем работу с дисплеем.
    myOLED.setFont(SmallFontRus);                                         // Указываем шрифт который требуется использовать для вывода цифр и текста.
}                                                                         //
                                                                          //
void loop(){                                                              //
    myOLED.clrScr();                                                      // Чистим экран.
    myOLED.print(F("Большие буквы:"),    0,       7);                     // Выводим текст начиная с координаты 0x7.
    myOLED.print(F("ABCDEFGHIJKLM"),     OLED_C, 23);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 23.
    myOLED.print(F("NOPQRSTUVWXYZ"),     OLED_C, 31);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 31.
    myOLED.print(F("АБВГДЕЁЖЗИЙКЛМНОП"), OLED_C, 47);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 47.
    myOLED.print(F("РСТУФХЦЧШЩЪЫЬЭЮЯ"),  OLED_C, 55);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 55.
    delay (5000);                                                         // Ждём 5 секунд.
                                                                          //
    myOLED.clrScr();                                                      // Чистим экран.
    myOLED.print(F("Маленькие буквы:"),  0,       7);                     // Выводим текст начиная с координаты 0x7.
    myOLED.print(F("abcdefghijklm"),     OLED_C, 23);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 23.
    myOLED.print(F("nopqrstuvwxyz"),     OLED_C, 31);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 31.
    myOLED.print(F("абвгдеёжзийклмноп"), OLED_C, 47);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 47.
    myOLED.print(F("рстуфхцчшщъыьэюя"),  OLED_C, 55);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 55.
    delay (5000);                                                         // Ждём 5 секунд.
                                                                          //
    myOLED.clrScr();                                                      // Чистим экран.
    myOLED.print(F("Цифры:"),            0,       7);                     // Выводим текст начиная с координаты 0x7.
    myOLED.print(F("012346789"),         OLED_C, 23);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 23.
    myOLED.print( 100,                   0, 39     );                     // Выводим число начиная с координаты 0x39.
    myOLED.print( 100,                   0, 47, HEX); myOLED.print("h");  // Выводим число начиная с координаты 0x47, вывод осуществляется в 16-ричной системе и выводим текст в той же строке сразу после числа.
    myOLED.print( 100,                   0, 55, OCT); myOLED.print("o");  // Выводим число начиная с координаты 0x55, вывод осуществляется в 8-ричной системе и выводим текст в той же строке сразу после числа.
    myOLED.print( 100,                   0, 63, BIN); myOLED.print("b");  // Выводим число начиная с координаты 0x63, вывод осуществляется в 2-ичной системе и выводим текст в той же строке сразу после числа.
    delay (5000);                                                         // Ждём 5 секунд.
                                                                          //
    myOLED.clrScr();                                                      // Чистим экран.
    myOLED.print(F("Символы:"),          0,       7);                     // Выводим текст начиная с координаты 0x7.
    myOLED.print(F("{}[]()<>?!#$%&*"),   OLED_C, 31);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 31.
    myOLED.print(F("~`'\"^_-+=,.:;|/"),  OLED_C, 47);                     // Выводим текст по центру, координата нижней части текста по оси Y равна 47.
    delay (5000);                                                         // Ждём 5 секунд.
                                                                          //
    myOLED.clrScr();                                                      // Чистим экран.
    myOLED.print(F("Вычисления:"),       0,       7       ); delay(1000); // Выводим текст начиная с координаты 0x7.
    myOLED.print( 2,                     0,      31       ); delay(1000); // Выводим число начиная с координаты 0x31.
    myOLED.print( "+"                                     ); delay(1000); // Выводим текст в той же строке сразу после предыдущего числа.
    myOLED.print( 2                                       ); delay(1000); // Выводим число 2 в той же строке сразу после предыдущего текста.
    myOLED.print( "="                                     ); delay(1000); // Выводим текст в той же строке сразу после предыдущего числа.
    myOLED.print( 2+2                                     ); delay(1000); // Выводим результат сложения чисел 2+2, в той же строке сразу после предыдущего текста.
                                                             delay(1000); // Ждём 1 секунду.
    myOLED.print( 2,                     0,      47,     4); delay(1000); // Выводим число 2 начиная с координаты 0x47, вывод осуществляется в 4-ричной системе.
    myOLED.print( "+"                                     ); delay(1000); // Выводим текст в той же строке сразу после предыдущего числа.
    myOLED.print( 2,                     OLED_N, OLED_N, 4); delay(1000); // Выводим число 2 в той же строке сразу после предыдущего текста, вывод осуществляется в 4-ричной системе.
    myOLED.print( "="                                     ); delay(1000); // Выводим текст в той же строке сразу после предыдущего числа.
    myOLED.print( 2+2,                   OLED_N, OLED_N, 4); delay(1000); // Выводим результат сложения чисел 2+2, в той же строке сразу после предыдущего текста, вывод осуществляется в 4-ричной системе.
    myOLED.print( " в 4-ой системе"                       );              // Выводим текст в той же строке сразу после предыдущего результата.
    delay (5000);                                                         // Ждём 5 секунд.
}                                                                         //
