#include <avr/pgmspace.h>						//	Содержимое картинок на примере массива Img_Logo:
												//	Массивы изображений начинаются с двух чисел - ширины и высоты изображения в пикселях.
												//	Далее следуют байты данных:
												//	Для визуализации разбейте массив на несколько строк, так, что бы количество байт в каждой строке совпало с шириной изображения.
												//	Для массива Img_Logo, имеющего размеры 27x16 получится две строки данных, по 27 байт в каждой строке.
												//	Если каждый байт записать битами, снизу вверх (внизу старший бит, сверху младший бит), то можно увидеть изображение.
												//
												//	Значение байта (hex):	7F,	7F,	7F,	0F,	0F,	0F,	0F,	0F,	0F,	0F,	0F,	03,	1B,	1B,	1B,	03,	0F,	0F,	0F,	0F,	0F,	0F,	0F,	0F,	7F,	7F,	7F
												//	0 бит: (младший)		1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	=	111111111111111111111111111	=	###########################
												//	1 бит:					1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	=	111111111111111111111111111	=	###########################
												//	2 бит:					1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	1	1	1	1	1	1	1	1	1	1	1	=	111111111110000011111111111	=	###########     ###########
												//	3 бит:					1	1	1	1	1	1	1	1	1	1	1	0	1	1	1	0	1	1	1	1	1	1	1	1	1	1	1	=	111111111110111011111111111	=	########### ### ###########
												//	4 бит:					1	1	1	0	0	0	0	0	0	0	0	0	1	1	1	0	0	0	0	0	0	0	0	0	1	1	1	=	111000000000111000000000111	=	###         ###         ###
												//	5 бит:					1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	1	1	=	111000000000000000000000111	=	###                     ###
												//	6 бит:					1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	1	1	=	111000000000000000000000111	=	###                     ###
												//	7 бит: (старший)		0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	=	000000000000000000000000000	=	                           
												//	Значение байта (hex):	FF,	FF,	FF,	F0,	F0,	F0,	C0,	D8,	D8,	D8,	C0,	F0,	F0,	00,	F0,	F0,	C0,	D8,	D8,	D8,	C0,	F0,	F0,	F0,	FF,	FF,	FF
												//	0 бит: (младший)		1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	1	1	=	111000000000000000000000111	=	###                     ###
												//	1 бит:					1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	1	1	=	111000000000000000000000111	=	###                     ###
												//	2 бит:					1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	1	1	=	111000000000000000000000111	=	###                     ###
												//	3 бит:					1	1	1	0	0	0	0	1	1	1	0	0	0	0	0	0	0	1	1	1	0	0	0	0	1	1	1	=	111000011100000001110000111	=	###    ###       ###    ###
												//	4 бит:					1	1	1	1	1	1	0	1	1	1	0	1	1	0	1	1	0	1	1	1	0	1	1	1	1	1	1	=	111111011101101101110111111	=	###### ### ## ## ### ######
												//	5 бит:					1	1	1	1	1	1	0	0	0	0	0	1	1	0	1	1	0	0	0	0	0	1	1	1	1	1	1	=	111111000001101100000111111	=	######     ## ##     ######
												//	6 бит:					1	1	1	1	1	1	1	1	1	1	1	1	1	0	1	1	1	1	1	1	1	1	1	1	1	1	1	=	111111111111101111111111111	=	############# #############
												//	7 бит: (старший)		1	1	1	1	1	1	1	1	1	1	1	1	1	0	1	1	1	1	1	1	1	1	1	1	1	1	1	=	111111111111101111111111111	=	############# #############
												//
const uint8_t Img_Logo[] PROGMEM = {			//	Логотип iArduino
27,16,											//	Размер картинки 27x16 пикселей.
0x7F, 0x7F, 0x7F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x03, 0x1B, 0x1B, 0x1B, 0x03, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x7F, 0x7F, 0x7F,
0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF0, 0xC0, 0xD8, 0xD8, 0xD8, 0xC0, 0xF0, 0xF0, 0x00, 0xF0, 0xF0, 0xC0, 0xD8, 0xD8, 0xD8, 0xC0, 0xF0, 0xF0, 0xF0, 0xFF, 0xFF, 0xFF
};												//
												//
const uint8_t Img_Alarm[] PROGMEM = {			//	Будильник
9,8,											//	Размер картинки 9x8 пикселей.
0x06, 0xBB, 0x45, 0x82, 0x9E, 0x92, 0x45, 0xBB, 0x06
};												//
												//
const uint8_t Img_Antenna[] PROGMEM = {			//	Антенна
10,8,											//	Размер картинки 10x8 пикселей.
0x01, 0x03, 0x06, 0x0C, 0xFF, 0xFF, 0x0C, 0x06, 0x03, 0x01
};												//
												//
const uint8_t Img_Arrow_down[] PROGMEM = {		//	Стрелка вниз
8,8,											//	Размер картинки 8x8 пикселей.
0x04, 0x0C, 0x1C, 0x3C, 0x3C, 0x1C, 0x0C, 0x04	//
};												//
												//
const uint8_t Img_Arrow_left[] PROGMEM = {		//	Стрелка влево
8,8,											//	Размер картинки 8x8 пикселей.
0x00, 0x00, 0x18, 0x3C, 0x7E, 0xFF, 0x00, 0x00	//
};												//
												//
const uint8_t Img_Arrow_right[] PROGMEM = {		//	Стрелка вправо
8,8,											//	Размер картинки 8x8 пикселей.
0x00, 0x00, 0xFF, 0x7E, 0x3C, 0x18, 0x00, 0x00	//
};												//
												//
const uint8_t Img_Arrow_up[] PROGMEM = {		//	Стрелка вверх
8,8,											//	Размер картинки 8x8 пикселей.
0x20, 0x30, 0x38, 0x3C, 0x3C, 0x38, 0x30, 0x20	//
};												//
												//
const uint8_t Img_Battery_0[] PROGMEM = {		//	Батарейка с зарядом 0
13,8,											//	Размер картинки 13x8 пикселей.
0xFF, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF, 0x3C
};												//
												//
const uint8_t Img_Battery_1[] PROGMEM = {		//	Батарейка с зарядом 1 (меньше половины)
13,8,											//	Размер картинки 13x8 пикселей.
0xFF, 0x81, 0xBD, 0xBD, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF, 0x3C
};												//
												//
const uint8_t Img_Battery_2[] PROGMEM = {		//	Батарейка с зарядом 2 (половина)
13,8,											//	Размер картинки 13x8 пикселей.
0xFF, 0x81, 0xBD, 0xBD, 0x81, 0xBD, 0xBD, 0x81, 0x81, 0x81, 0x81, 0xFF, 0x3C
};												//
												//
const uint8_t Img_Battery_3[] PROGMEM = {		//	Батарейка с зарядом 3 (больше половины)
13,8,											//	Размер картинки 13x8 пикселей.
0xFF, 0x81, 0xBD, 0xBD, 0x81, 0xBD, 0xBD, 0x81, 0xBD, 0xBD, 0x81, 0xFF, 0x3C
};												//
												//
const uint8_t Img_Battery_charging[] PROGMEM = {//	Батарейка заряжается
13,8,											//	Размер картинки 13x8 пикселей.
0xFF, 0x81, 0x81, 0x81, 0x99, 0xBF, 0xB9, 0xBF, 0x99, 0x81, 0x81, 0xFF, 0x3C
};												//
												//
const uint8_t Img_Battery_low[] PROGMEM = {		//	Батарейка разряжена
13,8,											//	Размер картинки 13x8 пикселей.
0xFF, 0x81, 0x81, 0xC3, 0xA5, 0x99, 0x99, 0xA5, 0xC3, 0x81, 0x81, 0xFF, 0x3C
};												//
												//
const uint8_t Img_BigBattery_low[] PROGMEM = {	//	Батарейка разряжена (большая картинка)
23,16,											//	Размер картинки 23x8 пикселей.
0xFC, 0xFC, 0x0D, 0x0F, 0x0E, 0x0C, 0x1C, 0x3C, 0x6C, 0xCC, 0x8C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xFC, 0xFC, 0xC0, 0xC0,
0x3F, 0x3F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x31, 0x33, 0x36, 0x3C, 0x38, 0x30, 0x70, 0xF0, 0xB0, 0x3F, 0x3F, 0x03, 0x03
};												//
												//
const uint8_t Img_Bluetooth[] PROGMEM = {		//	Значок Bluetooth
5,8,											//	Размер картинки 5x8 пикселей.
0x42, 0x24, 0xFF, 0x5A, 0x24					//
};												//
												//
const uint8_t Img_Call[] PROGMEM = {			//	Звонок вызова
8,8,											//	Размер картинки 8x8 пикселей.
0x0E, 0x1F, 0x3E, 0x70, 0xE5, 0xED, 0xE1, 0x4E	//
};												//
												//
const uint8_t Img_Call_in[] PROGMEM = {			//	Входящий звонок
8,8,											//	Размер картинки 8x8 пикселей.
0x0E, 0x1F, 0x3E, 0x70, 0xE0, 0xE7, 0xE6, 0x45	//
};												//
												//
const uint8_t Img_Call_out[] PROGMEM = {		//	Исходящий звонок
8,8,											//	Размер картинки 8x8 пикселей.
0x0E, 0x1F, 0x3E, 0x70, 0xE0, 0xE5, 0xE3, 0x47	//
};												//
												//
const uint8_t Img_Check[] PROGMEM = {			//	Галочка
7,8,											//	Размер картинки 7x8 пикселей.
0x30, 0x70, 0xE0, 0xF0, 0x7C, 0x1F, 0x07		//
};												//
												//
const uint8_t Img_Checkbox_off[] PROGMEM = {	//	
8,8,											//	Размер картинки 8x8 пикселей.
0x7E, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x7E	//
};												//
												//
const uint8_t Img_Checkbox_on[] PROGMEM = {		//	
8,8,											//	Размер картинки 8x8 пикселей.
0x7E, 0x81, 0x99, 0xB1, 0x99, 0x8D, 0x81, 0x7E	//
};												//
												//
const uint8_t Img_Dynamic[] PROGMEM = {			//	Динамик
10,8,											//	Размер картинки 10x8 пикселей.
0x3C, 0x24, 0x3C, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00
};												//
												//
const uint8_t Img_Dynamic_off[] PROGMEM = {		//	Динамик выключен
10,8,											//	Размер картинки 10x8 пикселей.
0x3C, 0x24, 0x3C, 0x42, 0xFF, 0x00, 0x24, 0x18, 0x18, 0x24
};												//
												//
const uint8_t Img_Dynamic_on[] PROGMEM = {		//	Динамик включен
10,8,											//	Размер картинки 10x8 пикселей.
0x3C, 0x24, 0x3C, 0x42, 0xFF, 0x00, 0x24, 0x99, 0x42, 0x3C
};												//
												//
const uint8_t Img_Level_1[] PROGMEM = {			//	Уровень приёма 1 (низкий)
11,8,											//	Размер картинки 11x8 пикселей.
0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};												//
												//
const uint8_t Img_Level_2[] PROGMEM = {			//	Уровень приёма 2 (ниже среднего)
11,8,											//	Размер картинки 11x8 пикселей.
0xC0, 0xC0, 0x00, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};												//
												//
const uint8_t Img_Level_3[] PROGMEM = {			//	Уровень приёма 3 (выше среднего)
11,8,											//	Размер картинки 11x8 пикселей.
0xC0, 0xC0, 0x00, 0xF0, 0xF0, 0x00, 0xFC, 0xFC, 0x00, 0x00, 0x00
};												//
												//
const uint8_t Img_Level_4[] PROGMEM = {			//	Уровень приёма 4 (уверенный)
11,8,											//	Размер картинки 11x8 пикселей.
0xC0, 0xC0, 0x00, 0xF0, 0xF0, 0x00, 0xFC, 0xFC, 0x00, 0xFF, 0xFF
};												//
												//
const uint8_t Img_Light[] PROGMEM = {			//	Свет
9,8,											//	Размер картинки 9x8 пикселей.
0x10, 0x92, 0x6C, 0x44, 0x93, 0x44, 0x6C, 0x92, 0x10
};												//
												//
const uint8_t Img_Melody[] PROGMEM = {			//	Звонок мелодии
4,8,											//	Размер картинки 4x8 пикселей.
0x40, 0xEC, 0xE6, 0x7F							//
};												//
												//
const uint8_t Img_Message[] PROGMEM = {			//	Сообщение (конверт)
10,8,											//	Размер картинки 10x8 пикселей.
0x7E, 0xA5, 0x99, 0x91, 0xA1, 0xA1, 0x91, 0x99, 0xA5, 0x7E
};												//
												//
const uint8_t Img_Netlevel_1[] PROGMEM = {		//	Уровень приёма сети 1 (ниже среднего)
8,8,											//	Размер картинки 8x8 пикселей.
0x07, 0x03, 0x05, 0x00, 0x00, 0x00, 0xC0, 0xC0	//
};												//
												//
const uint8_t Img_Netlevel_2[] PROGMEM = {		//	Уровень приёма сети 2 (средний)
8,8,											//	Размер картинки 8x8 пикселей.
0x07, 0x03, 0x05, 0xC0, 0xF0, 0x30, 0xD8, 0xD8	//
};												//
												//
const uint8_t Img_Netlevel_3[] PROGMEM = {		//	Уровень приёма сети 3 (выше среднего)
8,8,											//	Размер картинки 8x8 пикселей.
0xE3, 0xF9, 0x3C, 0xCE, 0xF6, 0x37, 0xDB, 0xDB	//
};												//
												//
const uint8_t Img_Radio_off[] PROGMEM = {		//	
8,8,											//	Размер картинки 8x8 пикселей.
0x3C, 0x42, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3C	//
};												//
												//
const uint8_t Img_Radio_on[] PROGMEM = {		//	
8,8,											//	Размер картинки 8x8 пикселей.
0x3C, 0x42, 0x99, 0xBD, 0xBD, 0x99, 0x42, 0x3C	//
};												//
												//
const uint8_t Img_Settings[] PROGMEM = {		//	Звонок настроек
8,8,											//	Размер картинки 8x8 пикселей.
0x5A, 0xFF, 0x66, 0xDB, 0xDB, 0x66, 0xFF, 0x5A	//
};												//
												//