//  Раскомментируйте для программной реализации шины I2C:    //
//  #define pin_SW_SDA 3                                     // Назначение любого вывода Arduino для работы в качестве линии SDA программной шины I2C.
//  #define pin_SW_SCL 9                                     // Назначение любого вывода Arduino для работы в качестве линии SCL программной шины I2C.
//  Раскомментируйте для совместимости с большинством плат:  //
//  #include <Wire.h>                                        // Библиотека iarduino_OLED_txt будет использовать методы и функции библиотеки Wire.
//  Ссылки для ознакомления:                                 //
//  Подробная информация о подключении модуля к шине I2C:    // http://wiki.iarduino.ru/page/i2c_connection/
//  Подробная информация о функциях и методах библиотеки:    // http://wiki.iarduino.ru/page/OLED_trema/
//  Библиотека  iarduino_OLED_txt (текстовая) экономит ОЗУ:  // http://iarduino.ru/file/341.html
//  Бибилиотека iarduino_OLED     (графическая):             // http://iarduino.ru/file/340.html
                                                             // 
#include <iarduino_OLED_txt.h>                               // Подключаем библиотеку iarduino_OLED_txt.
iarduino_OLED_txt myOLED(0x3C);                              // Объявляем объект myOLED, указывая адрес дисплея на шине I2C: 0x3C или 0x3D.
                                                             //
extern uint8_t MediumFontRus[];                              // Подключаем шрифт MediumFontRus.
                                                             // Если Вы не используете Кириллицу, то лучше подключить шрифт MediumFont, он займет меньше места в памяти программ.
void setup(){                                                //
    myOLED.begin();                                          // Инициируем работу с дисплеем.
    myOLED.setFont(MediumFontRus);                           // Указываем шрифт который требуется использовать для вывода цифр и текста.
}                                                            //
                                                             //
void loop(){                                                 //
    myOLED.clrScr();                                         // Чистим экран.
    myOLED.print(F("iArduino"), 15,     4);                  // Выводим текст начиная с 15 столбца 4 строки (высота шрифта 2 строки, он займёт строки 3 и 4).
    delay (500);                                             // Ждём пол секунды.
    myOLED.print(F("ABC"),      0,      1);                  // Выводим текст начиная с  0 столбца 1 строки (высота шрифта 2 строки, он займёт строки 0 и 1).
    delay (500);                                             // Ждём пол секунды.
    myOLED.print(F("XYZ"),      92,     7);                  // Выводим текст начиная с 92 столбца 7 строки (высота шрифта 2 строки, он займёт строки 6 и 7).
    delay (500);                                             // Ждём пол секунды.
    myOLED.print(F("abc"),      92,     1);                  // Выводим текст начиная с 92 столбца 1 строки (высота шрифта 2 строки, он займёт строки 0 и 1).
    delay (500);                                             // Ждём пол секунды.
    myOLED.print(F("xyz"),      0,      7);                  // Выводим текст начиная с  0 столбца 7 строки (высота шрифта 2 строки, он займёт строки 6 и 7).
    delay (5000);                                            // Ждём 5 секунд.
                                                             //
    myOLED.clrScr();                                         // Чистим экран.
    myOLED.print(F("iАрдуино"), OLED_C, 4);                  // Выводим по центру       4 строки (высота шрифта 2 строки, он займёт строки 3 и 4).
    delay (500);                                             // Ждём пол секунды.
    myOLED.print(F("АБВ"),      OLED_L, 1);                  // Выводим по левому  краю 1 строки (высота шрифта 2 строки, он займёт строки 0 и 1).
    delay (500);                                             // Ждём пол секунды.
    myOLED.print(F("ЭЮЯ"),      OLED_R, 7);                  // Выводим по правому краю 7 строки (высота шрифта 2 строки, он займёт строки 6 и 7).
    delay (500);                                             // Ждём пол секунды.
    myOLED.print(F("абв"),      OLED_R, 1);                  // Выводим по правому краю 1 строки (высота шрифта 2 строки, он займёт строки 0 и 1).
    delay (500);                                             // Ждём пол секунды.
    myOLED.print(F("эюя"),      OLED_L, 7);                  // Выводим по левому  краю 7 строки (высота шрифта 2 строки, он займёт строки 6 и 7).
    delay (5000);                                            // Ждём 5 секунд.
                                                             //
    myOLED.clrScr();                                         // Чистим экран.
    myOLED.print( 77, 0, 2 );                                // Выводим число 77 начиная с 0 столбца 2 строки.
    delay (500);                                             // Ждём пол секунды.
    myOLED.print( "+" );                                     // Выводим текст в той же строке сразу после предыдущего числа.
    delay (500);                                             // Ждём пол секунды.
    myOLED.print( 77 );                                      // Выводим число 77 в той же строке сразу после предыдущего текста.
    delay (500);                                             // Ждём пол секунды.
    myOLED.print( "=" );                                     // Выводим текст в той же строке сразу после предыдущего числа.
    delay (500);                                             // Ждём пол секунды.
    myOLED.print( 77+77 );                                   // Выводим результат сложения чисел 77+77, в той же строке сразу после предыдущего текста.
    delay (500);                                             // Ждём пол секунды.
    myOLED.print( 77, 0, 6, HEX );                           // Выводим число 77 начиная с 0 столбца 6 строки, вывод осуществляется в 16-ричной системе.
    delay (500);                                             // Ждём пол секунды.
    myOLED.print( "+" );                                     // Выводим текст в той же строке сразу после предыдущего числа.
    delay (500);                                             // Ждём пол секунды.
    myOLED.print( 77, OLED_N, OLED_N, HEX );                 // Выводим число 77 в той же строке сразу после предыдущего текста, вывод осуществляется в 16-ричной системе.
    delay (500);                                             // Ждём пол секунды.
    myOLED.print( "=" );                                     // Выводим текст в той же строке сразу после предыдущего числа.
    delay (500);                                             // Ждём пол секунды.
    myOLED.print( 77+77, OLED_N, OLED_N, HEX );              // Выводим результат сложения чисел 77+77, в той же строке сразу после предыдущего текста, вывод осуществляется в 16-ричной системе.
    delay (5000);                                            // Ждём 5 секунд.
                                                             //
    myOLED.clrScr();                                         // Чистим экран.
    myOLED.print(F("{}[]()<>?!" ), OLED_C, 1);               // Выводим текст по центру 1 строки (высота шрифта 2 строки, он займёт строки 0 и 1).
    myOLED.print(F("#$%&*~`'\"^"), OLED_C, 4);               // Выводим текст по центру 4 строки (высота шрифта 2 строки, он займёт строки 3 и 4).
    myOLED.print(F("_-+=,.:;|/" ), OLED_C, 7);               // Выводим текст по центру 7 строки (высота шрифта 2 строки, он займёт строки 6 и 7).
    delay (5000);                                            // Ждём 5 секунд.
}                                                            //
