//  Раскомментируйте для программной реализации шины I2C:              //
//  #define pin_SW_SDA 3                                               // Назначение любого вывода Arduino для работы в качестве линии SDA программной шины I2C.
//  #define pin_SW_SCL 9                                               // Назначение любого вывода Arduino для работы в качестве линии SCL программной шины I2C.
//  Раскомментируйте для совместимости с большинством плат:            //
//  #include <Wire.h>                                                  // Библиотека iarduino_OLED_txt будет использовать методы и функции библиотеки Wire.
//  Ссылки для ознакомления:                                           //
//  Подробная информация о подключении модуля к шине I2C:              // http://wiki.iarduino.ru/page/i2c_connection/
//  Подробная информация о функциях и методах библиотеки:              // http://wiki.iarduino.ru/page/OLED_trema/
//  Библиотека  iarduino_OLED_txt (текстовая) экономит ОЗУ:            // http://iarduino.ru/file/341.html
//  Бибилиотека iarduino_OLED     (графическая):                       // http://iarduino.ru/file/340.html
                                                                       // 
#include <iarduino_OLED_txt.h>                                         // Подключаем библиотеку iarduino_OLED_txt.
iarduino_OLED_txt myOLED(0x3C);                                        // Объявляем объект myOLED, указывая адрес дисплея на шине I2C: 0x3C или 0x3D.
                                                                       //
extern uint8_t SmallFontRus[];                                         // Подключаем шрифт SmallFontRus.
                                                                       // Если Вы не используете Кириллицу, то лучше подключить шрифт SmallFont, он займет меньше места в памяти программ.
void setup(){                                                          //
    myOLED.begin();                                                    // Инициируем работу с дисплеем.
    myOLED.setFont(SmallFontRus);                                      // Указываем шрифт который требуется использовать для вывода цифр и текста.
                                                                       //
    myOLED.print( 123456789 , 0, 0);                                   // Выводим целое положительное число начиная с 0 столбца 0 строки.
    myOLED.print(-123456789 , 0, 1);                                   // Выводим целое отрицательное число начиная с 0 столбца 1 строки.
    myOLED.print( 123456789 , 0, 2, HEX);                              // Выводим целое положительное число начиная с 0 столбца 2 строки, в 16-ричной системе счисления.
    myOLED.print( 123456789 , 0, 3, OCT);                              // Выводим целое положительное число начиная с 0 столбца 3 строки, в 8-ричной системе счисления.
    myOLED.print(-123.456789, 0, 4);                                   // Выводим число с плавающей точкой  начиная с 0 столбца 4 строки, по умолчанию отобразится 2 знака после запятой.
    myOLED.print( 123.456789, 0, 5, 3);                                // Выводим число с плавающей точкой  начиная с 0 столбца 5 строки, указывая 3 знака после запятой.
    myOLED.print( 123       , 0, 6, BIN);                              // Выводим целое положительное число начиная с 0 столбца 6 строки, в 2-ичной системе счисления.
    myOLED.print( 123       , 0, 7, 12);                               // Выводим целое положительное число начиная с 0 столбца 7 строки, в 12-ричной системе счисления.
}                                                                      //
                                                                       //
void loop(){}                                                          //
