//  Раскомментируйте для программной реализации шины I2C:    //
//  #define pin_SW_SDA 3                                     // Назначение любого вывода Arduino для работы в качестве линии SDA программной шины I2C.
//  #define pin_SW_SCL 9                                     // Назначение любого вывода Arduino для работы в качестве линии SCL программной шины I2C.
//  Раскомментируйте для совместимости с большинством плат:  //
//  #include <Wire.h>                                        // Библиотека iarduino_OLED_txt будет использовать методы и функции библиотеки Wire.
//  Ссылки для ознакомления:                                 //
//  Подробная информация о подключении модуля к шине I2C:    // http://wiki.iarduino.ru/page/i2c_connection/
//  Подробная информация о функциях и методах библиотеки:    // http://wiki.iarduino.ru/page/OLED_trema/
//  Библиотека  iarduino_OLED_txt (текстовая) экономит ОЗУ:  // http://iarduino.ru/file/341.html
//  Бибилиотека iarduino_OLED     (графическая):             // http://iarduino.ru/file/340.html
                                                             // 
#include <iarduino_OLED_txt.h>                               // Подключаем библиотеку iarduino_OLED_txt.
iarduino_OLED_txt myOLED_1(0x3C);                            // Объявляем объект myOLED_1, указывая адрес первого дисплея на шине I2C: 0x3C.
iarduino_OLED_txt myOLED_2(0x3D);                            // Объявляем объект myOLED_2, указывая адрес второго дисплея на шине I2C: 0x3D.
                                                             // 
extern uint8_t MediumFontRus[];                              // Подключаем шрифт MediumFontRus.
extern uint8_t SmallFontRus[];                               // Подключаем шрифт SmallFontRus.
                                                             // Если Вы не используете Кириллицу, то лучше подключить шрифты MediumFont и SmallFont, они займут меньше места в памяти программ.
void setup(){                                                //
    myOLED_1.begin  ();                                      // Инициируем работу с первым дисплеем.
    myOLED_2.begin  ();                                      // Инициируем работу с вторым дисплеем.
    myOLED_1.setFont(MediumFontRus);                         // Указываем шрифт который требуется использовать для вывода цифр и текста на первом дисплее.
    myOLED_2.setFont(MediumFontRus);                         // Указываем шрифт который требуется использовать для вывода цифр и текста на втором дисплее.
    myOLED_1.print  ("1 дисплей", OLED_C, 3);                // Выводим текст на первый дисплей по центру 3 строки (высота шрифта 2 строки, он займёт строки 2 и 3).
    myOLED_2.print  ("2 дисплей", OLED_C, 3);                // Выводим текст на второй дисплей по центру 3 строки (высота шрифта 2 строки, он займёт строки 2 и 3).
    myOLED_1.setFont(SmallFontRus);                          // Указываем шрифт который требуется использовать для вывода цифр и текста на первом дисплее.
    myOLED_2.setFont(SmallFontRus);                          // Указываем шрифт который требуется использовать для вывода цифр и текста на втором дисплее.
    myOLED_1.print  ("Адрес дисплея 0x3C", OLED_C, 5);       // Выводим текст на первый дисплей по центру 5 строки (высота шрифта 1 строка).
    myOLED_2.print  ("Адрес дисплея 0x3D", OLED_C, 5);       // Выводим текст на второй дисплей по центру 5 строки (высота шрифта 1 строка).
}                                                            //
                                                             //
void loop(){}                                                //
