#include <avr/pgmspace.h>						//	Номер байта п/п:		0	1	2	3	4	5							Номер байта п/п:		0	1	2	3	4	5
												//	Значение байта (hex):	00,	20,	54,	54,	54,	78,		буква «а»			Значение байта (hex):	00,	7F,	28,	44,	44,	38		буква «b»
												//	0 бит: (младший)		0	0	0	0	0	0	=	|      |			0 бит: (младший)		0	1	0	0	0	0	=	| #    |
												//	1 бит:					0	0	0	0	0	0	=	|      |			1 бит:					0	1	0	0	0	0	=	| #    |
												//	2 бит:					0	0	1	1	1	0	=	|  ### |			2 бит:					0	1	0	1	1	0	=	| # ## |
												//	3 бит:					0	0	0	0	0	1	=	|     #|			3 бит:					0	1	1	0	0	1	=	| ##  #|
												//	4 бит:					0	0	1	1	1	1	=	|  ####|			4 бит:					0	1	0	0	0	1	=	| #   #|
												//	5 бит:					0	1	0	0	0	1	=	| #   #|			5 бит:					0	1	1	0	0	1	=	| ##  #|
												//	6 бит:					0	0	1	1	1	1	=	|  ####|			6 бит:					0	1	0	1	1	0	=	| # ## |
												//	7 бит: (старший)		0	0	0	0	0	0	=	|      |			7 бит: (старший)		0	0	0	0	0	0	=	|      |
												//
												//	Для Кириллицы используется кодировка CP866.
												//
												
const uint8_t SmallFont[] PROGMEM =				//	Шрифт	SmallFont
{												//
0x06, 0x08, 0x20, 0x5F,							//	ширина символов (6), высота символов (8), код первого символа (32), количество символов (95)
												//
0x00, 0x00, 0x00, 0x00, 0x00, 0x00,				//	001)	0x20=032	пробел
0x00, 0x00, 0x00, 0x2F, 0x00, 0x00,				//	002)	0x21=033	!
0x00, 0x00, 0x07, 0x00, 0x07, 0x00,				//	003)	0x22=034	"
0x00, 0x14, 0x7F, 0x14, 0x7F, 0x14,				//	004)	0x23=035	#
0x00, 0x24, 0x2A, 0x7F, 0x2A, 0x12,				//	005)	0x24=036	$
0x00, 0x23, 0x13, 0x08, 0x64, 0x62,				//	006)	0x25=037	%
0x00, 0x36, 0x49, 0x55, 0x22, 0x50,				//	007)	0x26=038	&
0x00, 0x00, 0x05, 0x03, 0x00, 0x00,				//	008)	0x27=039	'
0x00, 0x00, 0x1C, 0x22, 0x41, 0x00,				//	009)	0x28=040	(
0x00, 0x00, 0x41, 0x22, 0x1C, 0x00,				//	010)	0x29=041	)
0x00, 0x14, 0x08, 0x3E, 0x08, 0x14,				//	011)	0x2A=042	*
0x00, 0x08, 0x08, 0x3E, 0x08, 0x08,				//	012)	0x2B=043	+
0x00, 0x00, 0x00, 0xA0, 0x60, 0x00,				//	013)	0x2C=044	,
0x00, 0x08, 0x08, 0x08, 0x08, 0x08,				//	014)	0x2D=045	-
0x00, 0x00, 0x60, 0x60, 0x00, 0x00,				//	015)	0x2E=046	.
0x00, 0x20, 0x10, 0x08, 0x04, 0x02,				//	016)	0x2F=047	/
												//
0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E,				//	017)	0x30=048	0
0x00, 0x00, 0x42, 0x7F, 0x40, 0x00,				//	018)	0x31=049	1
0x00, 0x42, 0x61, 0x51, 0x49, 0x46,				//	019)	0x32=050	2
0x00, 0x21, 0x41, 0x45, 0x4B, 0x31,				//	020)	0x33=051	3
0x00, 0x18, 0x14, 0x12, 0x7F, 0x10,				//	021)	0x34=052	4
0x00, 0x27, 0x45, 0x45, 0x45, 0x39,				//	022)	0x35=053	5
0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30,				//	023)	0x36=054	6
0x00, 0x01, 0x71, 0x09, 0x05, 0x03,				//	024)	0x37=055	7
0x00, 0x36, 0x49, 0x49, 0x49, 0x36,				//	025)	0x38=056	8
0x00, 0x06, 0x49, 0x49, 0x29, 0x1E,				//	026)	0x39=057	9
0x00, 0x00, 0x36, 0x36, 0x00, 0x00,				//	027)	0x3A=058	:
0x00, 0x00, 0x56, 0x36, 0x00, 0x00,				//	028)	0x3B=059	;
0x00, 0x08, 0x14, 0x22, 0x41, 0x00,				//	029)	0x3C=060	<
0x00, 0x14, 0x14, 0x14, 0x14, 0x14,				//	030)	0x3D=061	=
0x00, 0x00, 0x41, 0x22, 0x14, 0x08,				//	031)	0x3E=062	>
0x00, 0x02, 0x01, 0x51, 0x09, 0x06,				//	032)	0x3F=063	?
												//
0x00, 0x32, 0x49, 0x59, 0x51, 0x3E,				//	033)	0x40=064	@
0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C,				//	034)	0x41=065	A
0x00, 0x7F, 0x49, 0x49, 0x49, 0x36,				//	035)	0x42=066	B
0x00, 0x3E, 0x41, 0x41, 0x41, 0x22,				//	036)	0x43=067	C
0x00, 0x7F, 0x41, 0x41, 0x22, 0x1C,				//	037)	0x44=068	D
0x00, 0x7F, 0x49, 0x49, 0x49, 0x41,				//	038)	0x45=069	E
0x00, 0x7F, 0x09, 0x09, 0x09, 0x01,				//	039)	0x46=070	F
0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A,				//	040)	0x47=071	G
0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F,				//	041)	0x48=072	H
0x00, 0x00, 0x41, 0x7F, 0x41, 0x00,				//	042)	0x49=073	I
0x00, 0x20, 0x40, 0x41, 0x3F, 0x01,				//	043)	0x4A=074	J
0x00, 0x7F, 0x08, 0x14, 0x22, 0x41,				//	044)	0x4B=075	K
0x00, 0x7F, 0x40, 0x40, 0x40, 0x40,				//	045)	0x4C=076	L
0x00, 0x7F, 0x02, 0x0C, 0x02, 0x7F,				//	046)	0x4D=077	M
0x00, 0x7F, 0x04, 0x08, 0x10, 0x7F,				//	047)	0x4E=078	N
0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E,				//	048)	0x4F=079	O
												//
0x00, 0x7F, 0x09, 0x09, 0x09, 0x06,				//	049)	0x50=080	P
0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E,				//	050)	0x51=081	Q
0x00, 0x7F, 0x09, 0x19, 0x29, 0x46,				//	051)	0x52=082	R
0x00, 0x46, 0x49, 0x49, 0x49, 0x31,				//	052)	0x53=083	S
0x00, 0x01, 0x01, 0x7F, 0x01, 0x01,				//	053)	0x54=084	T
0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F,				//	054)	0x55=085	U
0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F,				//	055)	0x56=086	V
0x00, 0x3F, 0x40, 0x38, 0x40, 0x3F,				//	056)	0x57=087	W
0x00, 0x63, 0x14, 0x08, 0x14, 0x63,				//	057)	0x58=088	X
0x00, 0x07, 0x08, 0x70, 0x08, 0x07,				//	058)	0x59=089	Y
0x00, 0x61, 0x51, 0x49, 0x45, 0x43,				//	059)	0x5A=090	Z
0x00, 0x00, 0x7F, 0x41, 0x41, 0x00,				//	060)	0x5B=091	[
0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55,				//	061)	0x5C=092	обратный слеш
0x00, 0x00, 0x41, 0x41, 0x7F, 0x00,				//	062)	0x5D=093	]
0x00, 0x04, 0x02, 0x01, 0x02, 0x04,				//	063)	0x5E=094	^
0x00, 0x40, 0x40, 0x40, 0x40, 0x40,				//	064)	0x5F=095	_
												//
0x00, 0x00, 0x03, 0x05, 0x00, 0x00,				//	065)	0x60=096	`
0x00, 0x20, 0x54, 0x54, 0x54, 0x78,				//	066)	0x61=097	a
0x00, 0x7F, 0x28, 0x44, 0x44, 0x38,				//	067)	0x62=098	b
0x00, 0x38, 0x44, 0x44, 0x44, 0x20,				//	068)	0x63=099	c
0x00, 0x38, 0x44, 0x44, 0x48, 0x7F,				//	069)	0x64=100	d
0x00, 0x38, 0x54, 0x54, 0x54, 0x18,				//	070)	0x65=101	e
0x00, 0x08, 0x7E, 0x09, 0x01, 0x02,				//	071)	0x66=102	f
0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C,				//	072)	0x67=103	g
0x00, 0x7F, 0x08, 0x04, 0x04, 0x78,				//	073)	0x68=104	h
0x00, 0x00, 0x44, 0x7D, 0x40, 0x00,				//	074)	0x69=105	i
0x00, 0x40, 0x80, 0x84, 0x7D, 0x00,				//	075)	0x6A=106	j
0x00, 0x7F, 0x10, 0x28, 0x44, 0x00,				//	076)	0x6B=107	k
0x00, 0x00, 0x41, 0x7F, 0x40, 0x00,				//	077)	0x6C=108	l
0x00, 0x7C, 0x04, 0x18, 0x04, 0x78,				//	078)	0x6D=109	m
0x00, 0x7C, 0x08, 0x04, 0x04, 0x78,				//	079)	0x6E=110	n
0x00, 0x38, 0x44, 0x44, 0x44, 0x38,				//	080)	0x6F=111	o
												//
0x00, 0xFC, 0x24, 0x24, 0x24, 0x18,				//	081)	0x70=112	p
0x00, 0x18, 0x24, 0x24, 0x18, 0xFC,				//	082)	0x71=113	q
0x00, 0x7C, 0x08, 0x04, 0x04, 0x08,				//	083)	0x72=114	r
0x00, 0x48, 0x54, 0x54, 0x54, 0x20,				//	084)	0x73=115	s
0x00, 0x04, 0x3F, 0x44, 0x40, 0x20,				//	085)	0x74=116	t
0x00, 0x3C, 0x40, 0x40, 0x20, 0x7C,				//	086)	0x75=117	u
0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C,				//	087)	0x76=118	v
0x00, 0x3C, 0x40, 0x30, 0x40, 0x3C,				//	088)	0x77=119	w
0x00, 0x44, 0x28, 0x10, 0x28, 0x44,				//	089)	0x78=120	x
0x00, 0x1C, 0xA0, 0xA0, 0xA0, 0x7C,				//	090)	0x79=121	y
0x00, 0x44, 0x64, 0x54, 0x4C, 0x44,				//	091)	0x7A=122	z
0x00, 0x00, 0x10, 0x7C, 0x82, 0x00,				//	092)	0x7B=123	{
0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,				//	093)	0x7C=124	|
0x00, 0x00, 0x82, 0x7C, 0x10, 0x00,				//	094)	0x7D=125	}
0x00, 0x00, 0x06, 0x09, 0x09, 0x06,				//	095)	0x7E=126	~
												//
0												//	В таблице имеется (0) пустых интервалов. См. шрифты с Русскими символами.
};												//

const uint8_t SmallFontRus[] PROGMEM =			//	Шрифт	SmallFontRus
{												//
0x06, 0x08, 0x20, 0xB0,							//	ширина символов (6), высота символов (8), код первого символа (32), количество символов (176)
												//
0x00, 0x00, 0x00, 0x00, 0x00, 0x00,				//	001)	0x20=032	пробел
0x00, 0x00, 0x00, 0x2F, 0x00, 0x00,				//	002)	0x21=033	!
0x00, 0x00, 0x07, 0x00, 0x07, 0x00,				//	003)	0x22=034	"
0x00, 0x14, 0x7F, 0x14, 0x7F, 0x14,				//	004)	0x23=035	#
0x00, 0x24, 0x2A, 0x7F, 0x2A, 0x12,				//	005)	0x24=036	$
0x00, 0x23, 0x13, 0x08, 0x64, 0x62,				//	006)	0x25=037	%
0x00, 0x36, 0x49, 0x55, 0x22, 0x50,				//	007)	0x26=038	&
0x00, 0x00, 0x05, 0x03, 0x00, 0x00,				//	008)	0x27=039	'
0x00, 0x00, 0x1C, 0x22, 0x41, 0x00,				//	009)	0x28=040	(
0x00, 0x00, 0x41, 0x22, 0x1C, 0x00,				//	010)	0x29=041	)
0x00, 0x14, 0x08, 0x3E, 0x08, 0x14,				//	011)	0x2A=042	*
0x00, 0x08, 0x08, 0x3E, 0x08, 0x08,				//	012)	0x2B=043	+
0x00, 0x00, 0x00, 0xA0, 0x60, 0x00,				//	013)	0x2C=044	,
0x00, 0x08, 0x08, 0x08, 0x08, 0x08,				//	014)	0x2D=045	-
0x00, 0x00, 0x60, 0x60, 0x00, 0x00,				//	015)	0x2E=046	.
0x00, 0x20, 0x10, 0x08, 0x04, 0x02,				//	016)	0x2F=047	/
												//
0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E,				//	017)	0x30=048	0
0x00, 0x00, 0x42, 0x7F, 0x40, 0x00,				//	018)	0x31=049	1
0x00, 0x42, 0x61, 0x51, 0x49, 0x46,				//	019)	0x32=050	2
0x00, 0x21, 0x41, 0x45, 0x4B, 0x31,				//	020)	0x33=051	3
0x00, 0x18, 0x14, 0x12, 0x7F, 0x10,				//	021)	0x34=052	4
0x00, 0x27, 0x45, 0x45, 0x45, 0x39,				//	022)	0x35=053	5
0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30,				//	023)	0x36=054	6
0x00, 0x01, 0x71, 0x09, 0x05, 0x03,				//	024)	0x37=055	7
0x00, 0x36, 0x49, 0x49, 0x49, 0x36,				//	025)	0x38=056	8
0x00, 0x06, 0x49, 0x49, 0x29, 0x1E,				//	026)	0x39=057	9
0x00, 0x00, 0x36, 0x36, 0x00, 0x00,				//	027)	0x3A=058	:
0x00, 0x00, 0x56, 0x36, 0x00, 0x00,				//	028)	0x3B=059	;
0x00, 0x08, 0x14, 0x22, 0x41, 0x00,				//	029)	0x3C=060	<
0x00, 0x14, 0x14, 0x14, 0x14, 0x14,				//	030)	0x3D=061	=
0x00, 0x00, 0x41, 0x22, 0x14, 0x08,				//	031)	0x3E=062	>
0x00, 0x02, 0x01, 0x51, 0x09, 0x06,				//	032)	0x3F=063	?
												//
0x00, 0x32, 0x49, 0x59, 0x51, 0x3E,				//	033)	0x40=064	@
0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C,				//	034)	0x41=065	A
0x00, 0x7F, 0x49, 0x49, 0x49, 0x36,				//	035)	0x42=066	B
0x00, 0x3E, 0x41, 0x41, 0x41, 0x22,				//	036)	0x43=067	C
0x00, 0x7F, 0x41, 0x41, 0x22, 0x1C,				//	037)	0x44=068	D
0x00, 0x7F, 0x49, 0x49, 0x49, 0x41,				//	038)	0x45=069	E
0x00, 0x7F, 0x09, 0x09, 0x09, 0x01,				//	039)	0x46=070	F
0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A,				//	040)	0x47=071	G
0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F,				//	041)	0x48=072	H
0x00, 0x00, 0x41, 0x7F, 0x41, 0x00,				//	042)	0x49=073	I
0x00, 0x20, 0x40, 0x41, 0x3F, 0x01,				//	043)	0x4A=074	J
0x00, 0x7F, 0x08, 0x14, 0x22, 0x41,				//	044)	0x4B=075	K
0x00, 0x7F, 0x40, 0x40, 0x40, 0x40,				//	045)	0x4C=076	L
0x00, 0x7F, 0x02, 0x0C, 0x02, 0x7F,				//	046)	0x4D=077	M
0x00, 0x7F, 0x04, 0x08, 0x10, 0x7F,				//	047)	0x4E=078	N
0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E,				//	048)	0x4F=079	O
												//
0x00, 0x7F, 0x09, 0x09, 0x09, 0x06,				//	049)	0x50=080	P
0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E,				//	050)	0x51=081	Q
0x00, 0x7F, 0x09, 0x19, 0x29, 0x46,				//	051)	0x52=082	R
0x00, 0x46, 0x49, 0x49, 0x49, 0x31,				//	052)	0x53=083	S
0x00, 0x01, 0x01, 0x7F, 0x01, 0x01,				//	053)	0x54=084	T
0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F,				//	054)	0x55=085	U
0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F,				//	055)	0x56=086	V
0x00, 0x3F, 0x40, 0x38, 0x40, 0x3F,				//	056)	0x57=087	W
0x00, 0x63, 0x14, 0x08, 0x14, 0x63,				//	057)	0x58=088	X
0x00, 0x07, 0x08, 0x70, 0x08, 0x07,				//	058)	0x59=089	Y
0x00, 0x61, 0x51, 0x49, 0x45, 0x43,				//	059)	0x5A=090	Z
0x00, 0x00, 0x7F, 0x41, 0x41, 0x00,				//	060)	0x5B=091	[
0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55,				//	061)	0x5C=092	обратный слеш
0x00, 0x00, 0x41, 0x41, 0x7F, 0x00,				//	062)	0x5D=093	]
0x00, 0x04, 0x02, 0x01, 0x02, 0x04,				//	063)	0x5E=094	^
0x00, 0x40, 0x40, 0x40, 0x40, 0x40,				//	064)	0x5F=095	_
												//
0x00, 0x00, 0x03, 0x05, 0x00, 0x00,				//	065)	0x60=096	`
0x00, 0x20, 0x54, 0x54, 0x78, 0x40,				//	066)	0x61=097	a
0x00, 0x7F, 0x28, 0x44, 0x44, 0x38,				//	067)	0x62=098	b
0x00, 0x38, 0x44, 0x44, 0x44, 0x20,				//	068)	0x63=099	c
0x00, 0x38, 0x44, 0x44, 0x48, 0x7F,				//	069)	0x64=100	d
0x00, 0x38, 0x54, 0x54, 0x54, 0x18,				//	070)	0x65=101	e
0x00, 0x08, 0x7E, 0x09, 0x01, 0x02,				//	071)	0x66=102	f
0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C,				//	072)	0x67=103	g
0x00, 0x7F, 0x08, 0x04, 0x04, 0x78,				//	073)	0x68=104	h
0x00, 0x00, 0x44, 0x7D, 0x40, 0x00,				//	074)	0x69=105	i
0x00, 0x40, 0x80, 0x84, 0x7D, 0x00,				//	075)	0x6A=106	j
0x00, 0x7F, 0x10, 0x28, 0x44, 0x00,				//	076)	0x6B=107	k
0x00, 0x00, 0x41, 0x7F, 0x40, 0x00,				//	077)	0x6C=108	l
0x00, 0x7C, 0x04, 0x18, 0x04, 0x78,				//	078)	0x6D=109	m
0x00, 0x7C, 0x08, 0x04, 0x04, 0x78,				//	079)	0x6E=110	n
0x00, 0x38, 0x44, 0x44, 0x44, 0x38,				//	080)	0x6F=111	o
												//
0x00, 0xFC, 0x24, 0x24, 0x24, 0x18,				//	081)	0x70=112	p
0x00, 0x18, 0x24, 0x24, 0x18, 0xFC,				//	082)	0x71=113	q
0x00, 0x7C, 0x08, 0x04, 0x04, 0x08,				//	083)	0x72=114	r
0x00, 0x48, 0x54, 0x54, 0x54, 0x20,				//	084)	0x73=115	s
0x00, 0x04, 0x3F, 0x44, 0x40, 0x20,				//	085)	0x74=116	t
0x00, 0x3C, 0x40, 0x40, 0x20, 0x7C,				//	086)	0x75=117	u
0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C,				//	087)	0x76=118	v
0x00, 0x3C, 0x40, 0x30, 0x40, 0x3C,				//	088)	0x77=119	w
0x00, 0x44, 0x28, 0x10, 0x28, 0x44,				//	089)	0x78=120	x
0x00, 0x1C, 0xA0, 0xA0, 0xA0, 0x7C,				//	090)	0x79=121	y
0x00, 0x44, 0x64, 0x54, 0x4C, 0x44,				//	091)	0x7A=122	z
0x00, 0x00, 0x10, 0x7C, 0x82, 0x00,				//	092)	0x7B=123	{
0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,				//	093)	0x7C=124	|
0x00, 0x00, 0x82, 0x7C, 0x10, 0x00,				//	094)	0x7D=125	}
0x00, 0x10, 0x08, 0x10, 0x20, 0x10,				//	095)	0x7E=126	~
0   , 0   , 0   , 0   , 0   , 0   ,				//	096)	0x7F=127	⌂
												//
0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C,				//	097)	0x80=128	А
0x00, 0x7F, 0x49, 0x49, 0x49, 0x31,				//	098)	0x81=129	Б
0x00, 0x7F, 0x45, 0x45, 0x45, 0x3A,				//	099)	0x82=130	В
0x00, 0x7F, 0x01, 0x01, 0x01, 0x03,				//	100)	0x83=131	Г
0x00, 0x60, 0x3F, 0x21, 0x3F, 0x60,				//	101)	0x84=132	Д
0x00, 0x7F, 0x49, 0x49, 0x49, 0x41,				//	102)	0x85=133	Е
0x00, 0x73, 0x0C, 0x7F, 0x0C, 0x73,				//	103)	0x86=134	Ж
0x00, 0x22, 0x41, 0x49, 0x49, 0x36,				//	104)	0x87=135	З
0x00, 0x7F, 0x10, 0x08, 0x04, 0x7F,				//	105)	0x88=136	И
0x00, 0x7E, 0x20, 0x11, 0x08, 0x7E,				//	106)	0x89=137	Й
0x00, 0x7F, 0x08, 0x14, 0x22, 0x41,				//	107)	0x8A=138	К
0x00, 0x40, 0x3F, 0x01, 0x01, 0x7F,				//	108)	0x8B=139	Л
0x00, 0x7F, 0x06, 0x08, 0x06, 0x7F,				//	109)	0x8C=140	М
0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F,				//	110)	0x8D=141	Н
0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E,				//	111)	0x8E=142	О
0x00, 0x7F, 0x01, 0x01, 0x01, 0x7F,				//	112)	0x8F=143	П
												//
0x00, 0x7F, 0x09, 0x09, 0x09, 0x06,				//	113)	0x90=144	Р
0x00, 0x3E, 0x41, 0x41, 0x41, 0x22,				//	114)	0x91=145	С
0x00, 0x03, 0x01, 0x7F, 0x01, 0x03,				//	115)	0x92=146	Т
0x00, 0x61, 0x26, 0x18, 0x06, 0x01,				//	116)	0x93=147	У
0x00, 0x1C, 0x22, 0x7F, 0x22, 0x1C,				//	117)	0x94=148	Ф
0x00, 0x63, 0x14, 0x08, 0x14, 0x63,				//	118)	0x95=149	Х
0x00, 0x3F, 0x20, 0x20, 0x3F, 0x60,				//	119)	0x96=150	Ц
0x00, 0x07, 0x08, 0x08, 0x08, 0x7F,				//	120)	0x97=151	Ч
0x00, 0x7F, 0x40, 0x7F, 0x40, 0x7F,				//	121)	0x98=152	Ш
0x00, 0x3F, 0x20, 0x3F, 0x20, 0x7F,				//	122)	0x99=153	Щ
0x00, 0x01, 0x7F, 0x48, 0x48, 0x30,				//	123)	0x9A=154	Ъ
0x00, 0x7F, 0x48, 0x78, 0x00, 0x7F,				//	124)	0x9B=155	Ы
0x00, 0x7F, 0x48, 0x48, 0x30, 0x00,				//	125)	0x9C=156	Ь
0x00, 0x41, 0x49, 0x49, 0x2A, 0x1C,				//	126)	0x9D=157	Э
0x00, 0x7F, 0x10, 0x3E, 0x41, 0x3E,				//	127)	0x9E=158	Ю
0x00, 0x66, 0x19, 0x09, 0x09, 0x7F,				//	128)	0x9F=159	Я
												//
0x00, 0x20, 0x54, 0x54, 0x78, 0x40,				//	129)	0xA0=160	а
0x00, 0x3E, 0x49, 0x45, 0x45, 0x38,				//	130)	0xA1=161	б
0x00, 0x7C, 0x54, 0x54, 0x58, 0x20,				//	131)	0xA2=162	в
0x00, 0x7C, 0x04, 0x04, 0x0C, 0x00,				//	132)	0xA3=163	г
0x00, 0x38, 0x45, 0x45, 0x49, 0x3E,				//	133)	0xA4=164	д
0x00, 0x38, 0x54, 0x54, 0x54, 0x18,				//	134)	0xA5=165	е
0x00, 0x4C, 0x30, 0x7C, 0x30, 0x4C,				//	135)	0xA6=166	ж
0x00, 0x28, 0x44, 0x54, 0x28, 0x00,				//	136)	0xA7=167	з
0x00, 0x7C, 0x20, 0x10, 0x7C, 0x00,				//	137)	0xA8=168	и
0x00, 0x7C, 0x21, 0x11, 0x7C, 0x00,				//	138)	0xA9=169	й
0x00, 0x7C, 0x10, 0x28, 0x44, 0x00,				//	139)	0xAA=170	к
0x00, 0x40, 0x3C, 0x04, 0x04, 0x7C,				//	140)	0xAB=171	л
0x00, 0x7C, 0x08, 0x10, 0x08, 0x7C,				//	141)	0xAC=172	м
0x00, 0x7C, 0x10, 0x10, 0x7C, 0x00,				//	142)	0xAD=173	н
0x00, 0x38, 0x44, 0x44, 0x44, 0x38,				//	143)	0xAE=174	о
0x00, 0x7C, 0x04, 0x04, 0x7C, 0x00,				//	144)	0xAF=175	п
												//
0x00, 0xFC, 0x28, 0x44, 0x44, 0x38,				//	145)	0xE0=224	р
0x00, 0x38, 0x44, 0x44, 0x44, 0x28,				//	146)	0xE1=225	с
0x00, 0x04, 0x04, 0x7C, 0x04, 0x04,				//	147)	0xE2=226	т
0x00, 0x4C, 0x50, 0x50, 0x50, 0x3C,				//	148)	0xE3=227	у
0x00, 0x38, 0x44, 0xFE, 0x44, 0x38,				//	149)	0xE4=228	ф
0x00, 0x44, 0x28, 0x10, 0x28, 0x44,				//	150)	0xE5=229	х
0x00, 0x7C, 0x40, 0x40, 0x7C, 0xC0,				//	151)	0xE6=230	ц
0x00, 0x1C, 0x10, 0x10, 0x7C, 0x00,				//	152)	0xE7=231	ч
0x00, 0x7C, 0x40, 0x7C, 0x40, 0x7C,				//	153)	0xE8=232	ш
0x00, 0x7C, 0x40, 0x7C, 0x40, 0xFC,				//	154)	0xE9=233	щ
0x00, 0x04, 0x7C, 0x50, 0x70, 0x00,				//	155)	0xEA=234	ъ
0x00, 0x7C, 0x50, 0x70, 0x00, 0x7C,				//	156)	0xEB=235	ы
0x00, 0x00, 0x7C, 0x50, 0x70, 0x00,				//	157)	0xEC=236	ь
0x00, 0x28, 0x44, 0x54, 0x38, 0x00,				//	158)	0xED=237	э
0x00, 0x7C, 0x10, 0x38, 0x44, 0x38,				//	159)	0xEE=238	ю
0x00, 0x08, 0x54, 0x34, 0x14, 0x7C,				//	160)	0xEF=239	я
												//
0x00, 0x7E, 0x4B, 0x4A, 0x4B, 0x42,				//	161)	0xF0=240	Ё
0x00, 0x38, 0x55, 0x54, 0x55, 0x18,				//	162)	0xF1=241	ё
0   , 0   , 0   , 0   , 0   , 0   ,				//	163)	0xF2=242	Є
0   , 0   , 0   , 0   , 0   , 0   ,				//	164)	0xF3=243	є
0   , 0   , 0   , 0   , 0   , 0   ,				//	165)	0xF4=244	Ї
0   , 0   , 0   , 0   , 0   , 0   ,				//	166)	0xF5=245	ї
0   , 0   , 0   , 0   , 0   , 0   ,				//	167)	0xF6=246	Ў
0   , 0   , 0   , 0   , 0   , 0   ,				//	168)	0xF7=247	ў
0x00, 0x00, 0x06, 0x09, 0x09, 0x06,				//	169)	0xF8=248	°
0   , 0   , 0   , 0   , 0   , 0   ,				//	170)	0xF9=249	∙
0   , 0   , 0   , 0   , 0   , 0   ,				//	171)	0xFA=250	·
0   , 0   , 0   , 0   , 0   , 0   ,				//	172)	0xFB=251	√
0   , 0   , 0   , 0   , 0   , 0   ,				//	173)	0xFC=252	№
0   , 0   , 0   , 0   , 0   , 0   ,				//	174)	0xFD=253	¤
0   , 0   , 0   , 0   , 0   , 0   ,				//	175)	0xFE=254	■
0   , 0   , 0   , 0   , 0   , 0   ,				//	176)	0xFF=255	 
												//
0x01, 0xAF, 0x30								//	В таблице имеется (1) пустой интервал, который находится после символа с кодом (175) и состоит из (48) отсутствующих символов.
												//	Допускается использовать до 3 пустых интервалов.	Пример: 0x03, 0xAA, 0x10, 0xCC, 0x10, 0xEE, 0x10
};												//														3 пустых интервала, по (16) отсутствующий символов в каждом, находятся после символов с кодами (170, 204 и 238).

const uint8_t MediumFont[] PROGMEM =																							//	Шрифт	MediumFont
{																															//
0x0C,0x10,0x20,0x5F,																										//	ширина символов (12), высота символов (16), код первого символа (32), количество символов (95)
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	001)	0x20=032	пробел
0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x67,0x67,0x00,0x00,0x00,0x00,0x00,	//	002)	0x21=033	!
0x00,0x00,0x00,0x16,0x0E,0x00,0x00,0x16,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	003)	0x22=034	"
0x00,0x00,0x60,0xE0,0xF8,0x7E,0x6E,0xE0,0xF8,0x7E,0x6E,0x00,0x00,0x76,0x7E,0x1F,0x07,0x76,0x7E,0x1F,0x07,0x06,0x00,0x00,	//	004)	0x23=035	#
0x00,0x78,0xFC,0xCE,0x86,0xFF,0xFF,0x86,0x9E,0x1C,0x18,0x00,0x00,0x18,0x38,0x79,0x61,0xFF,0xFF,0x61,0x73,0x3F,0x1E,0x00,	//	005)	0x24=036	$
0x00,0x3C,0x7E,0x66,0x7E,0xBC,0xE0,0x78,0x1E,0x06,0x00,0x00,0x00,0x00,0x60,0x78,0x1E,0x07,0x3D,0x7E,0x66,0x7E,0x3C,0x00,	//	006)	0x25=037	%
0x00,0x00,0x00,0x80,0x80,0xFC,0xFE,0xE6,0xE6,0x7E,0x3C,0x00,0x00,0x1E,0x3F,0x73,0x61,0x61,0x71,0x7F,0x3F,0x7C,0x6C,0x00,	//	007)	0x26=038	&
0x00,0x00,0x00,0x00,0x00,0x16,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	008)	0x27=039	'
0x00,0x00,0x00,0x00,0xF0,0xFC,0x0E,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x3F,0x70,0xC0,0x00,0x00,0x00,0x00,	//	009)	0x28=040	(
0x00,0x00,0x00,0x00,0x03,0x0E,0xFC,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x70,0x3F,0x0F,0x00,0x00,0x00,0x00,	//	010)	0x29=041	)
0x00,0x00,0x00,0x08,0x78,0x3C,0x3C,0x78,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	011)	0x2A=042	*
0x00,0x00,0x80,0x80,0x80,0xF0,0xF0,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x0F,0x0F,0x01,0x01,0x01,0x00,0x00,	//	012)	0x2B=043	+
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB0,0x70,0x00,0x00,0x00,0x00,0x00,	//	013)	0x2C=044	,
0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,	//	014)	0x2D=045	-
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x00,0x00,0x00,0x00,0x00,	//	015)	0x2E=046	.
0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0x78,0x1E,0x06,0x00,0x00,0x00,0x00,0x60,0x78,0x1E,0x07,0x01,0x00,0x00,0x00,0x00,0x00,	//	016)	0x2F=047	/
																															//
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	017)	0x30=048	0
0x00,0x00,0x00,0x30,0x38,0x1C,0xFE,0xFE,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,	//	018)	0x31=049	1
0x00,0x18,0x1C,0x1E,0x06,0x06,0x06,0x86,0xCE,0xFC,0x78,0x00,0x00,0x78,0x7C,0x7E,0x66,0x67,0x63,0x63,0x61,0x70,0x70,0x00,	//	019)	0x32=050	2
0x00,0x0E,0x0E,0x06,0x06,0xC6,0xE6,0xF6,0xFE,0x9E,0x0E,0x00,0x00,0x18,0x38,0x78,0x60,0x60,0x60,0x60,0x71,0x3F,0x1F,0x00,	//	020)	0x33=051	3
0x00,0x00,0x80,0xC0,0xE0,0x70,0x38,0x1C,0xFE,0xFE,0x06,0x00,0x00,0x07,0x07,0x07,0x06,0x06,0x06,0x66,0x7F,0x7F,0x66,0x00,	//	021)	0x34=052	4
0x00,0xFE,0xFE,0xE6,0x66,0x66,0x66,0x66,0xE6,0xCE,0x8E,0x00,0x00,0x18,0x38,0x78,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	022)	0x35=053	5
0x00,0xF8,0xFC,0xCE,0xC6,0xC6,0xC6,0xC6,0xDE,0x9C,0x18,0x00,0x00,0x1F,0x3F,0x71,0x60,0x60,0x60,0x60,0x71,0x3F,0x1F,0x00,	//	023)	0x36=054	6
0x00,0x1E,0x1E,0x06,0x06,0x06,0x06,0x86,0xE6,0x7E,0x1E,0x00,0x00,0x00,0x00,0x00,0x60,0x78,0x1E,0x07,0x01,0x00,0x00,0x00,	//	024)	0x37=055	7
0x00,0x78,0xFC,0xCE,0x86,0x86,0x86,0x86,0xCE,0xFC,0x78,0x00,0x00,0x1E,0x3F,0x73,0x61,0x61,0x61,0x61,0x73,0x3F,0x1E,0x00,	//	025)	0x38=056	8
0x00,0xF8,0xFC,0x8E,0x06,0x06,0x06,0x06,0x8E,0xFC,0xF8,0x00,0x00,0x18,0x39,0x7B,0x63,0x63,0x63,0x63,0x73,0x3F,0x1F,0x00,	//	026)	0x39=057	9
0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00,	//	027)	0x3A=058	:
0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x1C,0x00,0x00,0x00,0x00,0x00,	//	028)	0x3B=059	;
0x00,0x00,0x80,0xC0,0xC0,0xE0,0x60,0x70,0x30,0x30,0x00,0x00,0x00,0x00,0x01,0x03,0x03,0x07,0x06,0x0E,0x0C,0x0C,0x00,0x00,	//	029)	0x3C=060	<
0x00,0x00,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x00,0x00,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x00,0x00,	//	030)	0x3D=061	=
0x00,0x00,0x30,0x30,0x70,0x60,0xE0,0xC0,0xC0,0x80,0x00,0x00,0x00,0x00,0x0C,0x0C,0x0E,0x06,0x07,0x03,0x03,0x01,0x00,0x00,	//	031)	0x3E=062	>
0x00,0x18,0x1C,0x1E,0x06,0x06,0x86,0x86,0xCE,0xFC,0x78,0x00,0x00,0x00,0x00,0x00,0x6E,0x6F,0x03,0x01,0x01,0x00,0x00,0x00,	//	032)	0x3F=063	?
																															//
0x00,0xF8,0xFC,0x0E,0xE6,0xF6,0x36,0xF6,0xF6,0x0E,0xFC,0xF8,0x00,0x1F,0x3F,0x70,0x67,0x6F,0x6C,0x6F,0x67,0x6C,0x2F,0x07,	//	033)	0x40=064	@
0x00,0x00,0xF0,0xFC,0x1E,0x06,0x06,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x63,0x03,0x03,0x63,0x7F,0x7F,0x60,0x00,	//	034)	0x41=065	A
0x00,0x06,0xFE,0xFE,0x86,0x86,0x86,0x86,0xCE,0xFC,0x78,0x00,0x00,0x60,0x7F,0x7F,0x61,0x61,0x61,0x61,0x73,0x3F,0x1E,0x00,	//	035)	0x42=066	B
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x1E,0x1C,0x18,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x78,0x38,0x18,0x00,	//	036)	0x43=067	C
0x00,0x06,0xFE,0xFE,0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00,0x00,0x60,0x7F,0x7F,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	037)	0x44=068	D
0x00,0x06,0xFE,0xFE,0x86,0x86,0x86,0xC6,0xC6,0x0E,0x0E,0x00,0x00,0x60,0x7F,0x7F,0x61,0x61,0x61,0x63,0x63,0x70,0x70,0x00,	//	038)	0x45=069	E
0x00,0x06,0xFE,0xFE,0x86,0x86,0xC6,0xC6,0x06,0x0E,0x0E,0x00,0x00,0x60,0x7F,0x7F,0x61,0x01,0x03,0x03,0x00,0x00,0x00,0x00,	//	039)	0x46=070	F
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x1E,0x1C,0x18,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x63,0x63,0x73,0x3F,0x1F,0x00,	//	040)	0x47=071	G
0x00,0x06,0xFE,0xFE,0x86,0x80,0x80,0x86,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x61,0x01,0x01,0x61,0x7F,0x7F,0x60,0x00,	//	041)	0x48=072	H
0x00,0x00,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	042)	0x49=073	I
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x18,0x38,0x78,0x60,0x60,0x70,0x3F,0x1F,0x00,0x00,	//	043)	0x4A=074	J
0x00,0x06,0xFE,0xFE,0x86,0x80,0xC0,0xF6,0x7E,0x1E,0x06,0x00,0x00,0x60,0x7F,0x7F,0x61,0x01,0x03,0x6F,0x7E,0x78,0x60,0x00,	//	044)	0x4B=075	K
0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x60,0x60,0x60,0x60,0x70,0x70,0x00,	//	045)	0x4C=076	L
0x00,0x06,0xFE,0xFE,0x78,0xE0,0xE0,0x78,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x60,0x01,0x01,0x60,0x7F,0x7F,0x60,0x00,	//	046)	0x4D=077	M
0x00,0x06,0xFE,0xFE,0x78,0xE0,0x80,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x60,0x01,0x07,0x1E,0x7F,0x7F,0x60,0x00,	//	047)	0x4E=078	N
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	048)	0x4F=079	O
																															//
0x00,0x06,0xFE,0xFE,0x06,0x06,0x06,0x06,0x8E,0xFC,0xF8,0x00,0x00,0x60,0x7F,0x7F,0x63,0x03,0x03,0x03,0x03,0x01,0x00,0x00,	//	049)	0x50=080	P
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x6C,0x7C,0x38,0x7F,0x6F,0x00,	//	050)	0x51=081	Q
0x00,0x06,0xFE,0xFE,0x06,0x06,0x06,0x06,0x8E,0xFC,0xF8,0x00,0x00,0x60,0x7F,0x7F,0x63,0x03,0x03,0x6F,0x7F,0x79,0x60,0x00,	//	051)	0x52=082	R
0x00,0x78,0xFC,0xCE,0x86,0x86,0x86,0x86,0x9E,0x1C,0x18,0x00,0x00,0x18,0x38,0x79,0x61,0x61,0x61,0x61,0x73,0x3F,0x1E,0x00,	//	052)	0x53=083	S
0x00,0x0E,0x0E,0x06,0x06,0xFE,0xFE,0x06,0x06,0x0E,0x0E,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	053)	0x54=084	T
0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x70,0x3F,0x1F,0x00,0x00,	//	054)	0x55=085	U
0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x03,0x0F,0x3E,0x78,0x78,0x3E,0x0F,0x03,0x00,0x00,	//	055)	0x56=086	V
0x00,0x06,0xFE,0xFE,0x06,0x80,0x80,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x1F,0x7F,0x78,0x1F,0x1F,0x78,0x7F,0x1F,0x00,0x00,	//	056)	0x57=087	W
0x00,0x06,0x1E,0x7E,0xF6,0xC0,0xC0,0xF6,0x7E,0x1E,0x06,0x00,0x00,0x60,0x78,0x7E,0x6F,0x03,0x03,0x6F,0x7E,0x78,0x60,0x00,	//	057)	0x58=088	X
0x00,0x06,0x7E,0xFE,0xC6,0x00,0x00,0xC6,0xFE,0x7E,0x06,0x00,0x00,0x00,0x00,0x01,0x63,0x7F,0x7F,0x63,0x01,0x00,0x00,0x00,	//	058)	0x59=089	Y
0x00,0x0E,0x0E,0x06,0x06,0x86,0xC6,0xE6,0x76,0x3E,0x1E,0x00,0x00,0x78,0x7C,0x6E,0x67,0x63,0x61,0x60,0x60,0x70,0x70,0x00,	//	059)	0x5A=090	Z
0x00,0x00,0x00,0x00,0xFF,0xFF,0x03,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xC0,0xC0,0xC0,0x00,0x00,0x00,	//	060)	0x5B=091	[
0x00,0x00,0x06,0x1E,0x78,0xE0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x1E,0x78,0x60,0x00,0x00,	//	061)	0x5C=092	обратный слеш
0x00,0x00,0x00,0x03,0x03,0x03,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xFF,0xFF,0x00,0x00,0x00,0x00,	//	062)	0x5D=093	]
0x00,0x00,0x00,0x30,0x3C,0x1E,0x1E,0x3C,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	063)	0x5E=094	^
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x00,	//	064)	0x5F=095	_
																															//
0x00,0x00,0x00,0x00,0x00,0x0E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	065)	0x60=096	`
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x00,0x1C,0x3E,0x77,0x63,0x63,0x63,0x33,0x7F,0x7F,0x60,0x00,	//	066)	0x61=097	a
0x00,0x06,0xFE,0xFE,0x66,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x60,0x7F,0x7F,0x30,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	067)	0x62=098	b
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0xF0,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x78,0x38,0x18,0x00,	//	068)	0x63=099	c
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x66,0xFE,0xFE,0x06,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x30,0x7F,0x7F,0x60,0x00,	//	069)	0x64=100	d
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x76,0x66,0x66,0x66,0x66,0x76,0x37,0x17,0x00,	//	070)	0x65=101	e
0x00,0x00,0x00,0x60,0xFC,0xFE,0x66,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,	//	071)	0x66=102	f
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x60,0xF0,0xF0,0x30,0x00,0x00,0x33,0x77,0xEE,0xCC,0xCC,0xCC,0xEE,0x7F,0x3F,0x00,0x00,	//	072)	0x67=103	g
0x00,0x06,0xFE,0xFE,0x66,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,	//	073)	0x68=104	h
0x00,0x00,0x00,0x00,0x30,0xF6,0xF6,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	074)	0x69=105	i
0x00,0x00,0x00,0x00,0x00,0x30,0xF6,0xF6,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x7F,0x3F,0x00,0x00,0x00,0x00,	//	075)	0x6A=106	j
0x00,0x06,0xFE,0xFE,0x06,0x80,0xF0,0xF0,0x70,0x30,0x30,0x00,0x00,0x60,0x7F,0x7F,0x63,0x07,0x0F,0x7C,0x78,0x70,0x60,0x00,	//	076)	0x6B=107	k
0x00,0x00,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	077)	0x6C=108	l
0x30,0xF0,0xE0,0x30,0x30,0xF0,0xE0,0x30,0x30,0xF0,0xE0,0x00,0x60,0x7F,0x7F,0x60,0x00,0x7F,0x7F,0x00,0x60,0x7F,0x7F,0x60,	//	078)	0x6D=109	m
0x00,0x30,0xF0,0xF0,0x60,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,	//	079)	0x6E=110	n
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	080)	0x6F=111	o
																															//
0x00,0x30,0xF0,0xF0,0x60,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0xC0,0xFF,0xFF,0xD8,0x30,0x30,0x30,0x38,0x1F,0x0F,0x00,	//	081)	0x70=112	p
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x60,0xF0,0xF0,0x30,0x00,0x00,0x0F,0x1F,0x38,0x30,0x30,0x30,0xD8,0xFF,0xFF,0xC0,0x00,	//	082)	0x71=113	q
0x00,0x00,0x30,0xF0,0xF0,0x60,0x30,0x30,0x70,0x60,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,0x00,0x00,	//	083)	0x72=114	r
0x00,0xE0,0xF0,0x30,0x30,0x30,0x30,0x30,0x70,0x70,0x60,0x00,0x00,0x19,0x3B,0x7B,0x63,0x63,0x63,0x63,0x77,0x3E,0x1C,0x00,	//	084)	0x73=115	s
0x00,0x00,0x00,0x30,0xFE,0xFE,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x7F,0x60,0x60,0x00,0x00,0x00,0x00,	//	085)	0x74=116	t
0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x30,0x7F,0x7F,0x60,0x00,	//	086)	0x75=117	u
0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x00,0x00,0x07,0x1F,0x78,0x78,0x1F,0x07,0x00,0x00,0x00,	//	087)	0x76=118	v
0x30,0xF0,0xF0,0x30,0x00,0x00,0x00,0x00,0x30,0xF0,0xF0,0x30,0x00,0x03,0x1F,0x7C,0x70,0x1E,0x1E,0x70,0x7C,0x1F,0x03,0x00,	//	088)	0x77=119	w
0x00,0x00,0x30,0x70,0xF0,0x80,0x80,0xF0,0x70,0x30,0x00,0x00,0x00,0x00,0x60,0x70,0x7D,0x0F,0x0F,0x7D,0x70,0x60,0x00,0x00,	//	089)	0x78=120	x
0x00,0x00,0x30,0xF0,0xC0,0x00,0x00,0xC0,0xF0,0x30,0x00,0x00,0x00,0x00,0x60,0x60,0x73,0x3F,0x0F,0x03,0x00,0x00,0x00,0x00,	//	090)	0x79=121	y
0x00,0x00,0x70,0x70,0x30,0x30,0xB0,0xF0,0xF0,0x70,0x00,0x00,0x00,0x00,0x78,0x7C,0x6E,0x67,0x63,0x61,0x70,0x70,0x00,0x00,	//	091)	0x7A=122	z
0x00,0x00,0x80,0xC0,0xFC,0x7E,0x07,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x3F,0x7E,0xE0,0xC0,0xC0,0x00,0x00,0x00,	//	092)	0x7B=123	{
0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00,	//	093)	0x7C=124	|
0x00,0x00,0x00,0x03,0x03,0x07,0x7E,0xFC,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xE0,0x7E,0x3F,0x03,0x01,0x00,0x00,	//	094)	0x7D=125	}
0x00,0x80,0xC0,0xC0,0xC0,0xC0,0x80,0x00,0x00,0x80,0x80,0x00,0x00,0x01,0x01,0x00,0x00,0x01,0x03,0x03,0x03,0x03,0x01,0x00,	//	095)	0x7E=126	~
																															//
0																															//	В таблице имеется (0) пустых интервалов. См. шрифты с Русскими символами.
};																															//

const uint8_t MediumFontRus[] PROGMEM =																						//	Шрифт	MediumFontRus
{																															//
0x0C,0x10,0x20,0xB0,																										//	ширина символов (12), высота символов (16), код первого символа (32), количество символов (176)
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	001)	0x20=032	пробел
0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x67,0x67,0x00,0x00,0x00,0x00,0x00,	//	002)	0x21=033	!
0x00,0x00,0x00,0x16,0x0E,0x00,0x00,0x16,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	003)	0x22=034	"
0x00,0x00,0x60,0xE0,0xF8,0x7E,0x6E,0xE0,0xF8,0x7E,0x6E,0x00,0x00,0x76,0x7E,0x1F,0x07,0x76,0x7E,0x1F,0x07,0x06,0x00,0x00,	//	004)	0x23=035	#
0x00,0x78,0xFC,0xCE,0x86,0xFF,0xFF,0x86,0x9E,0x1C,0x18,0x00,0x00,0x18,0x38,0x79,0x61,0xFF,0xFF,0x61,0x73,0x3F,0x1E,0x00,	//	005)	0x24=036	$
0x00,0x3C,0x7E,0x66,0x7E,0xBC,0xE0,0x78,0x1E,0x06,0x00,0x00,0x00,0x00,0x60,0x78,0x1E,0x07,0x3D,0x7E,0x66,0x7E,0x3C,0x00,	//	006)	0x25=037	%
0x00,0x00,0x00,0x80,0x80,0xFC,0xFE,0xE6,0xE6,0x7E,0x3C,0x00,0x00,0x1E,0x3F,0x73,0x61,0x61,0x71,0x7F,0x3F,0x7C,0x6C,0x00,	//	007)	0x26=038	&
0x00,0x00,0x00,0x00,0x00,0x16,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	008)	0x27=039	'
0x00,0x00,0x00,0x00,0xF0,0xFC,0x0E,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x3F,0x70,0xC0,0x00,0x00,0x00,0x00,	//	009)	0x28=040	(
0x00,0x00,0x00,0x00,0x03,0x0E,0xFC,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x70,0x3F,0x0F,0x00,0x00,0x00,0x00,	//	010)	0x29=041	)
0x00,0x00,0x00,0x08,0x78,0x3C,0x3C,0x78,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	011)	0x2A=042	*
0x00,0x00,0x80,0x80,0x80,0xF0,0xF0,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x0F,0x0F,0x01,0x01,0x01,0x00,0x00,	//	012)	0x2B=043	+
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB0,0x70,0x00,0x00,0x00,0x00,0x00,	//	013)	0x2C=044	,
0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,	//	014)	0x2D=045	-
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x00,0x00,0x00,0x00,0x00,	//	015)	0x2E=046	.
0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0x78,0x1E,0x06,0x00,0x00,0x00,0x00,0x60,0x78,0x1E,0x07,0x01,0x00,0x00,0x00,0x00,0x00,	//	016)	0x2F=047	/
																															//
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	017)	0x30=048	0
0x00,0x00,0x00,0x30,0x38,0x1C,0xFE,0xFE,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,	//	018)	0x31=049	1
0x00,0x18,0x1C,0x1E,0x06,0x06,0x06,0x86,0xCE,0xFC,0x78,0x00,0x00,0x78,0x7C,0x7E,0x66,0x67,0x63,0x63,0x61,0x70,0x70,0x00,	//	019)	0x32=050	2
0x00,0x0E,0x0E,0x06,0x06,0xC6,0xE6,0xF6,0xFE,0x9E,0x0E,0x00,0x00,0x18,0x38,0x78,0x60,0x60,0x60,0x60,0x71,0x3F,0x1F,0x00,	//	020)	0x33=051	3
0x00,0x00,0x80,0xC0,0xE0,0x70,0x38,0x1C,0xFE,0xFE,0x06,0x00,0x00,0x07,0x07,0x07,0x06,0x06,0x06,0x66,0x7F,0x7F,0x66,0x00,	//	021)	0x34=052	4
0x00,0xFE,0xFE,0xE6,0x66,0x66,0x66,0x66,0xE6,0xCE,0x8E,0x00,0x00,0x18,0x38,0x78,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	022)	0x35=053	5
0x00,0xF8,0xFC,0xCE,0xC6,0xC6,0xC6,0xC6,0xDE,0x9C,0x18,0x00,0x00,0x1F,0x3F,0x71,0x60,0x60,0x60,0x60,0x71,0x3F,0x1F,0x00,	//	023)	0x36=054	6
0x00,0x1E,0x1E,0x06,0x06,0x06,0x06,0x86,0xE6,0x7E,0x1E,0x00,0x00,0x00,0x00,0x00,0x60,0x78,0x1E,0x07,0x01,0x00,0x00,0x00,	//	024)	0x37=055	7
0x00,0x78,0xFC,0xCE,0x86,0x86,0x86,0x86,0xCE,0xFC,0x78,0x00,0x00,0x1E,0x3F,0x73,0x61,0x61,0x61,0x61,0x73,0x3F,0x1E,0x00,	//	025)	0x38=056	8
0x00,0xF8,0xFC,0x8E,0x06,0x06,0x06,0x06,0x8E,0xFC,0xF8,0x00,0x00,0x18,0x39,0x7B,0x63,0x63,0x63,0x63,0x73,0x3F,0x1F,0x00,	//	026)	0x39=057	9
0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00,	//	027)	0x3A=058	:
0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x1C,0x00,0x00,0x00,0x00,0x00,	//	028)	0x3B=059	;
0x00,0x00,0x80,0xC0,0xC0,0xE0,0x60,0x70,0x30,0x30,0x00,0x00,0x00,0x00,0x01,0x03,0x03,0x07,0x06,0x0E,0x0C,0x0C,0x00,0x00,	//	029)	0x3C=060	<
0x00,0x00,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x00,0x00,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x00,0x00,	//	030)	0x3D=061	=
0x00,0x00,0x30,0x30,0x70,0x60,0xE0,0xC0,0xC0,0x80,0x00,0x00,0x00,0x00,0x0C,0x0C,0x0E,0x06,0x07,0x03,0x03,0x01,0x00,0x00,	//	031)	0x3E=062	>
0x00,0x18,0x1C,0x1E,0x06,0x06,0x86,0x86,0xCE,0xFC,0x78,0x00,0x00,0x00,0x00,0x00,0x6E,0x6F,0x03,0x01,0x01,0x00,0x00,0x00,	//	032)	0x3F=063	?
																															//
0x00,0xF8,0xFC,0x0E,0xE6,0xF6,0x36,0xF6,0xF6,0x0E,0xFC,0xF8,0x00,0x1F,0x3F,0x70,0x67,0x6F,0x6C,0x6F,0x67,0x6C,0x2F,0x07,	//	033)	0x40=064	@
0x00,0x00,0xF0,0xFC,0x1E,0x06,0x06,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x63,0x03,0x03,0x63,0x7F,0x7F,0x60,0x00,	//	034)	0x41=065	A
0x00,0x06,0xFE,0xFE,0x86,0x86,0x86,0x86,0xCE,0xFC,0x78,0x00,0x00,0x60,0x7F,0x7F,0x61,0x61,0x61,0x61,0x73,0x3F,0x1E,0x00,	//	035)	0x42=066	B
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x1E,0x1C,0x18,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x78,0x38,0x18,0x00,	//	036)	0x43=067	C
0x00,0x06,0xFE,0xFE,0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00,0x00,0x60,0x7F,0x7F,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	037)	0x44=068	D
0x00,0x06,0xFE,0xFE,0x86,0x86,0x86,0xC6,0xC6,0x0E,0x0E,0x00,0x00,0x60,0x7F,0x7F,0x61,0x61,0x61,0x63,0x63,0x70,0x70,0x00,	//	038)	0x45=069	E
0x00,0x06,0xFE,0xFE,0x86,0x86,0xC6,0xC6,0x06,0x0E,0x0E,0x00,0x00,0x60,0x7F,0x7F,0x61,0x01,0x03,0x03,0x00,0x00,0x00,0x00,	//	039)	0x46=070	F
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x1E,0x1C,0x18,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x63,0x63,0x73,0x3F,0x1F,0x00,	//	040)	0x47=071	G
0x00,0x06,0xFE,0xFE,0x86,0x80,0x80,0x86,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x61,0x01,0x01,0x61,0x7F,0x7F,0x60,0x00,	//	041)	0x48=072	H
0x00,0x00,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	042)	0x49=073	I
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x18,0x38,0x78,0x60,0x60,0x70,0x3F,0x1F,0x00,0x00,	//	043)	0x4A=074	J
0x00,0x06,0xFE,0xFE,0x86,0x80,0xC0,0xF6,0x7E,0x1E,0x06,0x00,0x00,0x60,0x7F,0x7F,0x61,0x01,0x03,0x6F,0x7E,0x78,0x60,0x00,	//	044)	0x4B=075	K
0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x60,0x60,0x60,0x60,0x70,0x70,0x00,	//	045)	0x4C=076	L
0x00,0x06,0xFE,0xFE,0x78,0xE0,0xE0,0x78,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x60,0x01,0x01,0x60,0x7F,0x7F,0x60,0x00,	//	046)	0x4D=077	M
0x00,0x06,0xFE,0xFE,0x78,0xE0,0x80,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x60,0x01,0x07,0x1E,0x7F,0x7F,0x60,0x00,	//	047)	0x4E=078	N
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	048)	0x4F=079	O
																															//
0x00,0x06,0xFE,0xFE,0x06,0x06,0x06,0x06,0x8E,0xFC,0xF8,0x00,0x00,0x60,0x7F,0x7F,0x63,0x03,0x03,0x03,0x03,0x01,0x00,0x00,	//	049)	0x50=080	P
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x6C,0x7C,0x38,0x7F,0x6F,0x00,	//	050)	0x51=081	Q
0x00,0x06,0xFE,0xFE,0x06,0x06,0x06,0x06,0x8E,0xFC,0xF8,0x00,0x00,0x60,0x7F,0x7F,0x63,0x03,0x03,0x6F,0x7F,0x79,0x60,0x00,	//	051)	0x52=082	R
0x00,0x78,0xFC,0xCE,0x86,0x86,0x86,0x86,0x9E,0x1C,0x18,0x00,0x00,0x18,0x38,0x79,0x61,0x61,0x61,0x61,0x73,0x3F,0x1E,0x00,	//	052)	0x53=083	S
0x00,0x0E,0x0E,0x06,0x06,0xFE,0xFE,0x06,0x06,0x0E,0x0E,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	053)	0x54=084	T
0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x70,0x3F,0x1F,0x00,0x00,	//	054)	0x55=085	U
0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x03,0x0F,0x3E,0x78,0x78,0x3E,0x0F,0x03,0x00,0x00,	//	055)	0x56=086	V
0x00,0x06,0xFE,0xFE,0x06,0x80,0x80,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x1F,0x7F,0x78,0x1F,0x1F,0x78,0x7F,0x1F,0x00,0x00,	//	056)	0x57=087	W
0x00,0x06,0x1E,0x7E,0xF6,0xC0,0xC0,0xF6,0x7E,0x1E,0x06,0x00,0x00,0x60,0x78,0x7E,0x6F,0x03,0x03,0x6F,0x7E,0x78,0x60,0x00,	//	057)	0x58=088	X
0x00,0x06,0x7E,0xFE,0xC6,0x00,0x00,0xC6,0xFE,0x7E,0x06,0x00,0x00,0x00,0x00,0x01,0x63,0x7F,0x7F,0x63,0x01,0x00,0x00,0x00,	//	058)	0x59=089	Y
0x00,0x0E,0x0E,0x06,0x06,0x86,0xC6,0xE6,0x76,0x3E,0x1E,0x00,0x00,0x78,0x7C,0x6E,0x67,0x63,0x61,0x60,0x60,0x70,0x70,0x00,	//	059)	0x5A=090	Z
0x00,0x00,0x00,0x00,0xFF,0xFF,0x03,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xC0,0xC0,0xC0,0x00,0x00,0x00,	//	060)	0x5B=091	[
0x00,0x00,0x06,0x1E,0x78,0xE0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x1E,0x78,0x60,0x00,0x00,	//	061)	0x5C=092	обратный слеш
0x00,0x00,0x00,0x03,0x03,0x03,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xFF,0xFF,0x00,0x00,0x00,0x00,	//	062)	0x5D=093	]
0x00,0x00,0x00,0x30,0x3C,0x1E,0x1E,0x3C,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	063)	0x5E=094	^
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x00,	//	064)	0x5F=095	_
																															//
0x00,0x00,0x00,0x00,0x00,0x0E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	065)	0x60=096	`
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x00,0x1C,0x3E,0x77,0x63,0x63,0x63,0x33,0x7F,0x7F,0x60,0x00,	//	066)	0x61=097	a
0x00,0x06,0xFE,0xFE,0x66,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x60,0x7F,0x7F,0x30,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	067)	0x62=098	b
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0xF0,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x78,0x38,0x18,0x00,	//	068)	0x63=099	c
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x66,0xFE,0xFE,0x06,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x30,0x7F,0x7F,0x60,0x00,	//	069)	0x64=100	d
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x76,0x66,0x66,0x66,0x66,0x76,0x37,0x17,0x00,	//	070)	0x65=101	e
0x00,0x00,0x00,0x60,0xFC,0xFE,0x66,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,	//	071)	0x66=102	f
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x60,0xF0,0xF0,0x30,0x00,0x00,0x33,0x77,0xEE,0xCC,0xCC,0xCC,0xEE,0x7F,0x3F,0x00,0x00,	//	072)	0x67=103	g
0x00,0x06,0xFE,0xFE,0x66,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,	//	073)	0x68=104	h
0x00,0x00,0x00,0x00,0x30,0xF6,0xF6,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	074)	0x69=105	i
0x00,0x00,0x00,0x00,0x00,0x30,0xF6,0xF6,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x7F,0x3F,0x00,0x00,0x00,0x00,	//	075)	0x6A=106	j
0x00,0x06,0xFE,0xFE,0x06,0x80,0xF0,0xF0,0x70,0x30,0x30,0x00,0x00,0x60,0x7F,0x7F,0x63,0x07,0x0F,0x7C,0x78,0x70,0x60,0x00,	//	076)	0x6B=107	k
0x00,0x00,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	077)	0x6C=108	l
0x30,0xF0,0xE0,0x30,0x30,0xF0,0xE0,0x30,0x30,0xF0,0xE0,0x00,0x60,0x7F,0x7F,0x60,0x00,0x7F,0x7F,0x00,0x60,0x7F,0x7F,0x60,	//	078)	0x6D=109	m
0x00,0x30,0xF0,0xF0,0x60,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,	//	079)	0x6E=110	n
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	080)	0x6F=111	o
																															//
0x00,0x30,0xF0,0xF0,0x60,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0xC0,0xFF,0xFF,0xD8,0x30,0x30,0x30,0x38,0x1F,0x0F,0x00,	//	081)	0x70=112	p
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x60,0xF0,0xF0,0x30,0x00,0x00,0x0F,0x1F,0x38,0x30,0x30,0x30,0xD8,0xFF,0xFF,0xC0,0x00,	//	082)	0x71=113	q
0x00,0x00,0x30,0xF0,0xF0,0x60,0x30,0x30,0x70,0x60,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,0x00,0x00,	//	083)	0x72=114	r
0x00,0xE0,0xF0,0x30,0x30,0x30,0x30,0x30,0x70,0x70,0x60,0x00,0x00,0x19,0x3B,0x7B,0x63,0x63,0x63,0x63,0x77,0x3E,0x1C,0x00,	//	084)	0x73=115	s
0x00,0x00,0x00,0x30,0xFE,0xFE,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x7F,0x60,0x60,0x00,0x00,0x00,0x00,	//	085)	0x74=116	t
0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x30,0x7F,0x7F,0x60,0x00,	//	086)	0x75=117	u
0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x00,0x00,0x07,0x1F,0x78,0x78,0x1F,0x07,0x00,0x00,0x00,	//	087)	0x76=118	v
0x30,0xF0,0xF0,0x30,0x00,0x00,0x00,0x00,0x30,0xF0,0xF0,0x30,0x00,0x03,0x1F,0x7C,0x70,0x1E,0x1E,0x70,0x7C,0x1F,0x03,0x00,	//	088)	0x77=119	w
0x00,0x00,0x30,0x70,0xF0,0x80,0x80,0xF0,0x70,0x30,0x00,0x00,0x00,0x00,0x60,0x70,0x7D,0x0F,0x0F,0x7D,0x70,0x60,0x00,0x00,	//	089)	0x78=120	x
0x00,0x00,0x30,0xF0,0xC0,0x00,0x00,0xC0,0xF0,0x30,0x00,0x00,0x00,0x00,0x60,0x60,0x73,0x3F,0x0F,0x03,0x00,0x00,0x00,0x00,	//	090)	0x79=121	y
0x00,0x00,0x70,0x70,0x30,0x30,0xB0,0xF0,0xF0,0x70,0x00,0x00,0x00,0x00,0x78,0x7C,0x6E,0x67,0x63,0x61,0x70,0x70,0x00,0x00,	//	091)	0x7A=122	z
0x00,0x00,0x80,0xC0,0xFC,0x7E,0x07,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x3F,0x7E,0xE0,0xC0,0xC0,0x00,0x00,0x00,	//	092)	0x7B=123	{
0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00,	//	093)	0x7C=124	|
0x00,0x00,0x00,0x03,0x03,0x07,0x7E,0xFC,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xE0,0x7E,0x3F,0x03,0x01,0x00,0x00,	//	094)	0x7D=125	}
0x00,0x80,0xC0,0xC0,0xC0,0xC0,0x80,0x00,0x00,0x80,0x80,0x00,0x00,0x01,0x01,0x00,0x00,0x01,0x03,0x03,0x03,0x03,0x01,0x00,	//	095)	0x7E=126	~
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	096)	0x7F=127	⌂
																															//
0x00,0x00,0xF0,0xFC,0x1E,0x06,0x06,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x63,0x03,0x03,0x63,0x7F,0x7F,0x60,0x00,	//	097)	0x80=128	А
0x00,0x06,0xFE,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0x8E,0x0E,0x00,0x00,0x60,0x7F,0x7F,0x60,0x60,0x60,0x60,0x71,0x3F,0x1F,0x00,	//	098)	0x81=129	Б
0x00,0x06,0xFE,0xFE,0x86,0x86,0x86,0x86,0xCE,0xFC,0x78,0x00,0x00,0x60,0x7F,0x7F,0x61,0x61,0x61,0x61,0x73,0x3F,0x1E,0x00,	//	099)	0x82=130	В
0x00,0x06,0xFE,0xFE,0x06,0x06,0x06,0x06,0x06,0x0E,0x0E,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	100)	0x83=131	Г
0x00,0x00,0xF0,0xFC,0x1E,0x06,0x06,0x06,0xFE,0xFE,0x06,0x00,0x00,0x78,0x7F,0x1F,0x18,0x18,0x18,0x18,0x1F,0x7F,0x78,0x00,	//	101)	0x84=132	Д
0x00,0x06,0xFE,0xFE,0x86,0x86,0x86,0xC6,0xC6,0x0E,0x0E,0x00,0x00,0x60,0x7F,0x7F,0x61,0x61,0x61,0x63,0x63,0x70,0x70,0x00,	//	102)	0x85=133	Е
0x00,0x06,0x7E,0xFE,0xC0,0xFE,0xFE,0xC0,0xFE,0x7E,0x06,0x00,0x00,0x60,0x7E,0x7F,0x03,0x7F,0x7F,0x03,0x7F,0x7E,0x60,0x00,	//	103)	0x86=134	Ж
0x00,0x18,0x1C,0x1E,0x06,0x06,0xC6,0xC6,0xEE,0xFC,0x38,0x00,0x00,0x18,0x38,0x78,0x60,0x60,0x60,0x60,0x71,0x3F,0x1F,0x00,	//	104)	0x87=135	З
0x00,0x06,0xFE,0xFE,0x06,0x80,0xE0,0x78,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x1E,0x07,0x01,0x60,0x7F,0x7F,0x60,0x00,	//	105)	0x88=136	И
0x00,0x06,0xFE,0xFE,0x01,0x83,0xE3,0x79,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x1E,0x07,0x01,0x60,0x7F,0x7F,0x60,0x00,	//	106)	0x89=137	Й
0x00,0x06,0xFE,0xFE,0x86,0x80,0xC0,0xF6,0x7E,0x1E,0x06,0x00,0x00,0x60,0x7F,0x7F,0x61,0x01,0x03,0x6F,0x7E,0x78,0x60,0x00,	//	107)	0x8A=138	К
0x00,0x00,0xF0,0xFC,0x1E,0x06,0x06,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x3F,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,	//	108)	0x8B=139	Л
0x00,0x06,0xFE,0xFE,0x78,0xE0,0xE0,0x78,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x60,0x01,0x01,0x60,0x7F,0x7F,0x60,0x00,	//	109)	0x8C=140	М
0x00,0x06,0xFE,0xFE,0x86,0x80,0x80,0x86,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x61,0x01,0x01,0x61,0x7F,0x7F,0x60,0x00,	//	110)	0x8D=141	Н
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	111)	0x8E=142	О
0x00,0x06,0xFE,0xFE,0x06,0x06,0x06,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,	//	112)	0x8F=143	П
																															//
0x00,0x06,0xFE,0xFE,0x06,0x06,0x06,0x06,0x8E,0xFC,0xF8,0x00,0x00,0x60,0x7F,0x7F,0x63,0x03,0x03,0x03,0x03,0x01,0x00,0x00,	//	113)	0x90=144	Р
0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06,0x1E,0x1C,0x18,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x78,0x38,0x18,0x00,	//	114)	0x91=145	С
0x00,0x0E,0x0E,0x06,0x06,0xFE,0xFE,0x06,0x06,0x0E,0x0E,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	115)	0x92=146	Т
0x00,0x06,0x1E,0x7E,0xF6,0xC0,0xC0,0xF6,0x7E,0x1E,0x06,0x00,0x00,0x60,0x60,0x70,0x7D,0x1F,0x07,0x01,0x00,0x00,0x00,0x00,	//	116)	0x93=147	У
0x00,0xF0,0xF8,0x1C,0x0C,0xFE,0xFE,0x0C,0x1C,0xF8,0xF0,0x00,0x00,0x0F,0x1F,0x38,0x30,0x7F,0x7F,0x30,0x38,0x1F,0x0F,0x00,	//	117)	0x94=148	Ф
0x00,0x06,0x1E,0x7E,0xF6,0xC0,0xC0,0xF6,0x7E,0x1E,0x06,0x00,0x00,0x60,0x78,0x7E,0x6F,0x03,0x03,0x6F,0x7E,0x78,0x60,0x00,	//	118)	0x95=149	Х
0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x60,0x60,0x60,0x60,0x7F,0x7F,0xE0,0xE0,	//	119)	0x96=150	Ц
0x00,0x06,0xFE,0xFE,0x86,0x00,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x00,0x00,0x01,0x03,0x03,0x03,0x63,0x7F,0x7F,0x60,0x00,	//	120)	0x97=151	Ч
0x00,0x06,0xFE,0xFE,0x06,0xF0,0xF0,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x60,0x7F,0x7F,0x60,0x7F,0x7F,0x60,0x00,	//	121)	0x98=152	Ш
0x00,0x06,0xFE,0xFE,0x06,0xF0,0xF0,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x60,0x7F,0x7F,0x60,0x7F,0x7F,0xE0,0xE0,	//	122)	0x99=153	Щ
0x06,0x06,0xFE,0xFE,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x61,0x61,0x61,0x61,0x73,0x3F,0x1E,0x00,	//	123)	0x9A=154	Ъ
0x00,0x06,0xFE,0xFE,0x86,0x80,0x00,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x7F,0x7F,0x61,0x7F,0x1F,0x60,0x7F,0x7F,0x60,0x00,	//	124)	0x9B=155	Ы
0x00,0x06,0xFE,0xFE,0x86,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x61,0x61,0x61,0x61,0x73,0x3F,0x1E,0x00,	//	125)	0x9C=156	Ь
0x00,0x18,0x1C,0x1E,0x06,0x06,0x86,0x86,0x8E,0xFC,0xF8,0x00,0x00,0x18,0x38,0x78,0x60,0x60,0x61,0x61,0x71,0x3F,0x1F,0x00,	//	126)	0x9D=157	Э
0x00,0x06,0xFE,0xFE,0x86,0xF8,0xFC,0x0E,0x06,0x0E,0xFC,0xF8,0x00,0x60,0x7F,0x7F,0x61,0x1F,0x3F,0x70,0x60,0x70,0x3F,0x1F,	//	127)	0x9E=158	Ю
0x00,0xF8,0xFC,0x8E,0x06,0x06,0x06,0x06,0xFE,0xFE,0x06,0x00,0x00,0x60,0x79,0x7F,0x6F,0x03,0x03,0x63,0x7F,0x7F,0x60,0x00,	//	128)	0x9F=159	Я
																															//
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x00,0x1C,0x3E,0x77,0x63,0x63,0x63,0x33,0x7F,0x7F,0x60,0x00,	//	129)	0xA0=160	а
0x00,0x30,0xF0,0xF0,0x30,0x30,0x30,0x30,0x30,0x70,0x70,0x00,0x00,0x60,0x7F,0x7F,0x63,0x63,0x63,0x63,0x77,0x3E,0x1C,0x00,	//	130)	0xA1=161	б
0x00,0x30,0xF0,0xF0,0x30,0x30,0x30,0x30,0xF0,0xE0,0xC0,0x00,0x00,0x60,0x7F,0x7F,0x63,0x63,0x63,0x63,0x77,0x3F,0x1C,0x00,	//	131)	0xA2=162	в
0x00,0x30,0xF0,0xF0,0x30,0x30,0x30,0x30,0x30,0x70,0x70,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	132)	0xA3=163	г
0x00,0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0xF0,0xF0,0x30,0x00,0x00,0xF0,0xFF,0x3F,0x30,0x30,0x30,0x30,0x3F,0xFF,0xF0,0x00,	//	133)	0xA4=164	д
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x76,0x66,0x66,0x66,0x66,0x76,0x37,0x17,0x00,	//	134)	0xA5=165	е
0x00,0x30,0x70,0xF0,0x80,0xF0,0xF0,0x80,0xF0,0x70,0x30,0x00,0x00,0x60,0x70,0x7D,0x0F,0x7F,0x7F,0x0F,0x7D,0x70,0x60,0x00,	//	135)	0xA6=166	ж
0x00,0xC0,0xE0,0xF0,0x30,0x30,0x30,0x30,0xF0,0xE0,0xC0,0x00,0x00,0x18,0x38,0x78,0x60,0x63,0x63,0x63,0x77,0x3F,0x1C,0x00,	//	136)	0xA7=167	з
0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0xB0,0xF0,0xF0,0x30,0x00,0x00,0x60,0x7F,0x7F,0x7C,0x0E,0x07,0x63,0x7F,0x7F,0x60,0x00,	//	137)	0xA8=168	и
0x00,0x30,0xF0,0xF3,0x37,0x06,0x06,0xB7,0xF3,0xF0,0x30,0x00,0x00,0x60,0x7F,0x7F,0x7C,0x0E,0x07,0x63,0x7F,0x7F,0x60,0x00,	//	138)	0xA9=169	й
0x00,0x30,0xF0,0xF0,0x30,0x00,0x80,0xF0,0xF0,0x70,0x30,0x00,0x00,0x60,0x7F,0x7F,0x63,0x07,0x0F,0x7D,0x78,0x70,0x60,0x00,	//	139)	0xAA=170	к
0x00,0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0xF0,0xF0,0x30,0x00,0x00,0x60,0x7F,0x3F,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,	//	140)	0xAB=171	л
0x00,0x30,0xF0,0xF0,0xC0,0x80,0x80,0xC0,0xF0,0xF0,0x30,0x00,0x00,0x60,0x7F,0x7F,0x61,0x07,0x07,0x61,0x7F,0x7F,0x60,0x00,	//	141)	0xAC=172	м
0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x60,0x7F,0x7F,0x63,0x03,0x03,0x63,0x7F,0x7F,0x60,0x00,	//	142)	0xAD=173	н
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,	//	143)	0xAE=174	о
0x00,0x30,0xF0,0xF0,0x30,0x30,0x30,0x30,0xF0,0xF0,0x30,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,	//	144)	0xAF=175	п
																															//
0x00,0x30,0xF0,0xF0,0x60,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0xC0,0xFF,0xFF,0xD8,0x30,0x30,0x30,0x38,0x1F,0x0F,0x00,	//	145)	0xE0=224	р
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0xF0,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60,0x78,0x38,0x18,0x00,	//	146)	0xE1=225	с
0x00,0x70,0x70,0x30,0x30,0xF0,0xF0,0x30,0x30,0x70,0x70,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x60,0x00,0x00,0x00,0x00,	//	147)	0xE2=226	т
0x00,0x00,0x30,0xF0,0xF0,0x00,0x00,0xF0,0xF0,0x30,0x00,0x00,0x00,0x00,0x60,0x60,0x73,0x3F,0x0F,0x03,0x00,0x00,0x00,0x00,	//	148)	0xE3=227	у
0x00,0xC0,0xE0,0x70,0x30,0xF8,0xF8,0x30,0x70,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x70,0x60,0xFF,0xFF,0x60,0x70,0x3F,0x1F,0x00,	//	149)	0xE4=228	ф
0x00,0x00,0x30,0x70,0xF0,0x80,0x80,0xF0,0x70,0x30,0x00,0x00,0x00,0x00,0x60,0x70,0x7D,0x0F,0x0F,0x7D,0x70,0x60,0x00,0x00,	//	150)	0xE5=229	х
0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x60,0x7F,0x7F,0x60,0x60,0x60,0x60,0x7F,0x7F,0xE0,0xE0,	//	151)	0xE6=230	ц
0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x00,0x03,0x07,0x06,0x06,0x06,0x66,0x7F,0x7F,0x60,0x00,	//	152)	0xE7=231	ч
0x00,0x30,0xF0,0xF0,0x30,0x80,0x80,0x30,0xF0,0xF0,0x30,0x00,0x00,0x60,0x7F,0x7F,0x60,0x7F,0x7F,0x60,0x7F,0x7F,0x60,0x00,	//	153)	0xE8=232	ш
0x00,0x30,0xF0,0xF0,0x30,0x80,0x80,0x30,0xF0,0xF0,0x30,0x00,0x00,0x60,0x7F,0x7F,0x60,0x7F,0x7F,0x60,0x7F,0x7F,0xE0,0xE0,	//	154)	0xE9=233	щ
0x30,0x30,0xF0,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x63,0x63,0x63,0x63,0x77,0x3E,0x1C,0x00,	//	155)	0xEA=234	ъ
0x30,0xF0,0xF0,0x30,0x00,0x00,0x00,0x00,0x30,0xF0,0xF0,0x30,0x60,0x7F,0x7F,0x63,0x63,0x77,0x3E,0x1C,0x60,0x7F,0x7F,0x60,	//	156)	0xEB=235	ы
0x00,0x30,0xF0,0xF0,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x7F,0x7F,0x63,0x63,0x63,0x63,0x77,0x3E,0x1C,0x00,	//	157)	0xEC=236	ь
0x00,0xC0,0xE0,0xF0,0x30,0x30,0x30,0x30,0x70,0xE0,0xC0,0x00,0x00,0x18,0x38,0x78,0x60,0x60,0x63,0x63,0x73,0x3F,0x1F,0x00,	//	158)	0xED=237	э
0x30,0xF0,0xF0,0x30,0xC0,0xE0,0x70,0x30,0x30,0x70,0xE0,0xC0,0x60,0x7F,0x7F,0x63,0x1F,0x3F,0x70,0x60,0x60,0x70,0x3F,0x1F,	//	159)	0xEE=238	ю
0x00,0xC0,0xE0,0x70,0x30,0x30,0x30,0x30,0xF0,0xF0,0x30,0x00,0x00,0x61,0x73,0x7F,0x6E,0x06,0x06,0x66,0x7F,0x7F,0x60,0x00,	//	160)	0xEF=239	я
																															//
0x00,0x0C,0xFC,0xFF,0x8F,0x8C,0x8C,0xCF,0xCF,0x1C,0x1C,0x00,0x00,0x60,0x7F,0x7F,0x61,0x61,0x61,0x63,0x63,0x70,0x70,0x00,	//	161)	0xF0=240	Ё
0x00,0xC0,0xE0,0x76,0x36,0x30,0x30,0x36,0x76,0xE0,0xC0,0x00,0x00,0x1F,0x3F,0x76,0x66,0x66,0x66,0x66,0x76,0x37,0x17,0x00,	//	162)	0xF1=241	ё
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	163)	0xF2=242	Є
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	164)	0xF3=243	є
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	165)	0xF4=244	Ї
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	166)	0xF5=245	ї
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	167)	0xF6=246	Ў
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	168)	0xF7=247	ў
0x00,0x3C,0x7E,0x66,0x66,0x7E,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	169)	0xF8=248	°
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	170)	0xF9=249	∙
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	171)	0xFA=250	·
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	172)	0xFB=251	√
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	173)	0xFC=252	№
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	174)	0xFD=253	¤
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	175)	0xFE=254	■
0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,	//	176)	0xFF=255	 
																															//
0x01, 0xAF, 0x30																											//	В таблице имеется (1) пустой интервал, который находится после символа с кодом (175) и состоит из (48) отсутствующих символов.
																															//	Допускается использовать до 3 пустых интервалов.	Пример: 0x03, 0xAA, 0x10, 0xCC, 0x10, 0xEE, 0x10
};																															//														3 пустых интервала, по (16) отсутствующий символов в каждом, находятся после символов с кодами (170, 204 и 238).

const uint8_t MediumNumbers[] PROGMEM =																												//	Шрифт	MediumNumbers
{																																					//
0x0c, 0x10, 0x2d, 0x0d,																																//	ширина символов (12), высота символов (16), код первого символа (45), количество символов (13)
0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x00, 0x00,		//	001)	0x2D=045	-
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,		//	002)	0x2E=046	.
0x00, 0x00, 0x02, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x02, 0x00, 0x00, 0x00, 0x00, 0x81, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0x81, 0x00, 0x00,		//	003)	0x2F=047	/
0x00, 0xfc, 0x7a, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7a, 0xfc, 0x00, 0x00, 0x7e, 0xbc, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xbc, 0x7e, 0x00,		//	004)	0x30=048	0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x00,		//	005)	0x31=049	1
0x00, 0x00, 0x02, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x7a, 0xfc, 0x00, 0x00, 0x7e, 0xbd, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0x81, 0x00, 0x00,		//	006)	0x32=050	2
0x00, 0x00, 0x02, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x7a, 0xfc, 0x00, 0x00, 0x00, 0x81, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xbd, 0x7e, 0x00,		//	007)	0x33=051	3
0x00, 0xfc, 0x78, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x78, 0xfc, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3d, 0x7e, 0x00,		//	008)	0x34=052	4
0x00, 0xfc, 0x7a, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x02, 0x00, 0x00, 0x00, 0x00, 0x81, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xbd, 0x7e, 0x00,		//	009)	0x35=053	5
0x00, 0xfc, 0x7a, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x02, 0x00, 0x00, 0x00, 0x7e, 0xbd, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xbd, 0x7e, 0x00,		//	010)	0x36=054	6
0x00, 0x00, 0x02, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7a, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x00,		//	011)	0x37=055	7
0x00, 0xfc, 0x7a, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x7a, 0xfc, 0x00, 0x00, 0x7e, 0xbd, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xbd, 0x7e, 0x00,		//	012)	0x38=056	8
0x00, 0xfc, 0x7a, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x7a, 0xfc, 0x00, 0x00, 0x00, 0x81, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xbd, 0x7e, 0x00,		//	013)	0x39=057	9
																																					//
0																																					//	В таблице имеется (0) пустых интервалов. См. шрифты с Русскими символами.
};																																					//

const uint8_t BigNumbers[] PROGMEM =																																																								//	Шрифт	BigNumbers
{																																																																//
0x0e, 0x18, 0x2d, 0x0d,																																																											//	ширина символов (14), высота символов (24), код первого символа (45), количество символов (13)
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		//	001)	0x2D=045	-
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xe0, 0xe0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,		//	002)	0x2E=046	.
0x00, 0x00, 0x02, 0x06, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0x80, 0x00, 0x00,		//	003)	0x2F=047	/
0x00, 0xfc, 0xfa, 0xf6, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0xf6, 0xfa, 0xfc, 0x00, 0x00, 0xef, 0xc7, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xc7, 0xef, 0x00, 0x00, 0x7f, 0xbf, 0xdf, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xdf, 0xbf, 0x7f, 0x00,		//	004)	0x30=048	0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf8, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xc7, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x7f, 0x00,		//	005)	0x31=049	1
0x00, 0x00, 0x02, 0x06, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0xf6, 0xfa, 0xfc, 0x00, 0x00, 0xe0, 0xd0, 0xb8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3b, 0x17, 0x0f, 0x00, 0x00, 0x7f, 0xbf, 0xdf, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0x80, 0x00, 0x00,		//	006)	0x32=050	2
0x00, 0x00, 0x02, 0x06, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0xf6, 0xfa, 0xfc, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xbb, 0xd7, 0xef, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xdf, 0xbf, 0x7f, 0x00,		//	007)	0x33=051	3
0x00, 0xfc, 0xf8, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf8, 0xfc, 0x00, 0x00, 0x0f, 0x17, 0x3b, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xbb, 0xd7, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x7f, 0x00,		//	008)	0x34=052	4
0x00, 0xfc, 0xfa, 0xf6, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x0f, 0x17, 0x3b, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xb8, 0xd0, 0xe0, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xdf, 0xbf, 0x7f, 0x00,		//	009)	0x35=053	5
0x00, 0xfc, 0xfa, 0xf6, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0xef, 0xd7, 0xbb, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xb8, 0xd0, 0xe0, 0x00, 0x00, 0x7f, 0xbf, 0xdf, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xdf, 0xbf, 0x7f, 0x00,		//	010)	0x36=054	6
0x00, 0x00, 0x02, 0x06, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0xf6, 0xfa, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xc7, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x7f, 0x00,		//	011)	0x37=055	7
0x00, 0xfc, 0xfa, 0xf6, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0xf6, 0xfa, 0xfc, 0x00, 0x00, 0xef, 0xd7, 0xbb, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xbb, 0xd7, 0xef, 0x00, 0x00, 0x7f, 0xbf, 0xdf, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xdf, 0xbf, 0x7f, 0x00,		//	012)	0x38=056	8
0x00, 0xfc, 0xfa, 0xf6, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0xf6, 0xfa, 0xfc, 0x00, 0x00, 0x0f, 0x17, 0x3b, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xbb, 0xd7, 0xef, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xdf, 0xbf, 0x7f, 0x00,		//	013)	0x39=057	9
																																																																//
0																																																																//	В таблице имеется (0) пустых интервалов. См. шрифты с Русскими символами.
};																																																																//

const uint8_t MegaNumbers[] PROGMEM =																																																																																																																																														//	Шрифт	MegaNumbers
{																																																																																																																																																							//
0x18,0x28,0x2D,0x0D,																																																																																																																																																		//	ширина символов (24), высота символов (40), код первого символа (45), количество символов (13)
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	001)	0x2D=045	-	()
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xF8,0xFC,0xFE,0xFE,0xFC,0xF8,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	002)	0x2E=046	.
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xC0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x0F,0x1F,0x3F,0x3F,0x1F,0x0F,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0xFE,0xFF,0xFF,0xFE,0x7C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	003)	0x2F=047	/	(:)
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF8,0xF8,0xF8,0xF0,0xF0,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xF0,0xFC,0xFE,0x3F,0x07,0x01,0x03,0x03,0x07,0x0F,0x1F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFC,0xF0,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x0F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFC,0xF8,0xF0,0xE0,0xE0,0xC0,0x80,0xE0,0xF8,0xFF,0x3F,0x0F,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x07,0x07,0x0F,0x1F,0x1F,0x1F,0x0F,0x07,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	004)	0x30=048	0
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF0,0xE0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x07,0x07,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x0F,0x1F,0x3F,0x3F,0x1F,0x0F,0x07,0x03,0x01,0x00,0x00,0x00,0x00,0x00,	//	005)	0x31=049	1
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF8,0xF8,0xF0,0xF0,0xE0,0xC0,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x1C,0x3E,0x7F,0x7F,0x3F,0x1F,0x0F,0x07,0x03,0x03,0x01,0x83,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF8,0xFC,0xFF,0xFF,0x7F,0x3F,0x1F,0x07,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xF0,0xF8,0xFE,0xDF,0xEF,0xEF,0xE7,0xE3,0xE1,0xE1,0xE0,0xE0,0xC0,0xC0,0xC0,0xC0,0x80,0x00,0x00,0x00,0x00,0x1E,0x1F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0F,0x0F,0x1F,0x1F,0x0F,0x07,0x03,0x00,0x00,0x00,	//	006)	0x32=050	2
0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xE0,0xF0,0xF8,0xF8,0xF8,0xF0,0xF0,0xE0,0xE0,0xC0,0xC0,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x07,0x0F,0x1F,0x0F,0x07,0x03,0x01,0x81,0xC0,0xF0,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x0E,0x0E,0x0F,0x0F,0x0F,0x1F,0x3F,0xFF,0xFF,0xFF,0xF9,0xF0,0xE0,0xC0,0x00,0x00,0x00,0x00,0x18,0x3C,0x7E,0xFF,0xFF,0xFE,0xFC,0xF8,0xF0,0xE0,0xC0,0x80,0x00,0xC1,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,	//	007)	0x33=051	3
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xF8,0xF8,0xF8,0xF0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xE0,0xF8,0x3C,0x1F,0x07,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFC,0xFF,0xE7,0xE3,0xE0,0xE0,0xE0,0xE0,0xE0,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0xE0,0xE0,0xE0,0xE0,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xC3,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0x83,0xC3,0xC3,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x03,0x07,0x0F,0x0F,0x0F,0x07,0x03,0x01,0x01,0x00,0x00,0x00,	//	008)	0x34=052	4
0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0xFF,0x07,0x01,0x81,0xC1,0xC1,0xE1,0xF1,0xE1,0xE1,0xC1,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x3F,0x3F,0x1F,0x0E,0x07,0x07,0x07,0x07,0x0F,0x1F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFE,0xF8,0x00,0x00,0x00,0x00,0x00,0x60,0xF0,0xFC,0xFC,0xFC,0xF8,0xF0,0xF0,0xE0,0xC0,0xC0,0x80,0x80,0xE0,0xFF,0xFF,0x7F,0x3F,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,	//	009)	0x35=053	5
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF8,0xF8,0xF8,0xF0,0xF0,0xE0,0xC0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xF8,0xFC,0xFE,0x7F,0x0F,0x01,0x01,0x03,0x83,0x87,0xCF,0xCF,0xDF,0x8F,0x07,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xB8,0x1C,0x1E,0x0E,0x07,0x0F,0x1F,0x3F,0x7F,0xFF,0xFF,0xFF,0xFE,0xF8,0x00,0x00,0x00,0x00,0x00,0x0F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFC,0xF8,0xF0,0xE0,0xC0,0xC0,0x80,0xE0,0xFF,0xFF,0x3F,0x1F,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x07,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	010)	0x36=054	6
0x00,0x00,0x00,0x00,0xC0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0x78,0x38,0x00,0x00,0x00,0x00,0x18,0x1E,0x1F,0x07,0x03,0x03,0x01,0x01,0x01,0x81,0xC1,0xF1,0xF9,0xFD,0x3F,0x0F,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF0,0xFC,0xFE,0xFF,0xFF,0x3F,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	011)	0x37=055	7
0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFC,0xFF,0xFF,0xE7,0xC1,0xC1,0x81,0x81,0x81,0x81,0x83,0xC3,0xFF,0xFF,0x7F,0x3F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xCF,0xFF,0xFF,0x7F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x7F,0x7F,0xFF,0xFF,0xFE,0xF8,0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xF8,0xF0,0xE0,0xE0,0xC0,0xC0,0xC0,0xC0,0xC0,0xE0,0xE0,0xFB,0x7F,0x1F,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x1F,0x1F,0x0F,0x0F,0x07,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	012)	0x38=056	8
0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF0,0xE0,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xF8,0xFE,0xFF,0xFF,0x87,0x01,0x01,0x01,0x03,0x07,0x0F,0x1F,0x7F,0xFF,0xFF,0xFF,0xFE,0xFC,0xE0,0x00,0x00,0x00,0x00,0x03,0x1F,0x7F,0xFF,0xFF,0xFF,0xFE,0xFC,0xF8,0xF0,0x70,0x38,0x3C,0x1E,0xCF,0xFF,0xFF,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xF0,0xF9,0xFD,0xFB,0xF1,0xF0,0xE0,0xC0,0xC0,0xE0,0xFC,0xFF,0x7F,0x1F,0x0F,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x03,0x07,0x07,0x0F,0x0F,0x0F,0x07,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	//	013)	0x39=057	9
																																																																																																																																																							//
0																																																																																																																																																							//	В таблице имеется (0) пустых интервалов. См. шрифты с Русскими символами.
};																																																																																																																																																							//
